defmodule DaProductApp.Repo.Migrations.CreateTransactionOperations do
  use Ecto.Migration

  def change do
    create table(:transaction_operations, primary_key: false) do
      add :id, :bigint, primary_key: true, auto_increment: true
      add :transaction_id, references(:transactions, column: :id, type: :bigint, on_delete: :delete_all), null: false
      add :operation_type, :string, null: false
      add :operation_id, :string
      add :operation_request_id, :string

      # Amount fields
      add :operation_amount_value, :string
      add :operation_amount_currency, :string
      add :settlement_amount_value, :string
      add :settlement_amount_currency, :string

      # Status and result fields
      add :status, :string, null: false
      add :result_code, :string
      add :result_status, :string
      add :result_message, :text
      add :operation_time, :utc_datetime

      # Settlement/Quote fields
      add :settlement_quote_currency_pair, :string
      add :settlement_quote_expiry_time, :utc_datetime
      add :settlement_quote_id, :string
      add :settlement_quote_price, :string
      add :settlement_quote_start_time, :utc_datetime

      # Additional metadata
      add :reason, :text
      add :metadata, :map
      add :provider_response, :map

      timestamps()
    end

    create index(:transaction_operations, [:transaction_id])
    create index(:transaction_operations, [:operation_type])
    create index(:transaction_operations, [:status])
    create index(:transaction_operations, [:operation_id])
    create index(:transaction_operations, [:transaction_id, :operation_type])
  end
end
