defmodule DaProductApp.Repo.Migrations.CreateShukriaTerminals do
  use Ecto.Migration

  def change do
    create table(:shukria_terminals) do
      add :stid, :string, null: false
      add :pid, :string, null: false  # POS Terminal ID or similar
      add :ptid, :string, null: false # Payment Terminal ID or similar
      add :pmid, :string, null: false # Payment Method ID or similar
      add :status, :string, default: "active"
      add :description, :string
      
      timestamps()
    end

    create unique_index(:shukria_terminals, [:stid])
    create index(:shukria_terminals, [:status])
  end
end
