defmodule DaProductApp.Repo.Migrations.CreateSoftwareVersions do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE software_versions (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      software_id BIGINT UNSIGNED NOT NULL,
      cycle VARCHAR(255) NOT NULL,
      release_date DATE,
      eol_date DATE,
      latest_version VARCHAR(255),
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      CONSTRAINT fk_software FOREIGN KEY (software_id) REFERENCES softwares(id) ON DELETE CASCADE
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS software_versions")
  end
end
