defmodule DaProductApp.Repo.Migrations.CreateUsersProviders do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE users_providers (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      user_id BIGINT UNSIGNED NOT NULL,
      provider_id BIGINT UNSIGNED NOT NULL,
      assignment_status VARCHAR(255) NOT NULL DEFAULT 'active',
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      CONSTRAINT fk_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
      CONSTRAINT fk_provider FOREIGN KEY (provider_id) REFERENCES providers(id) ON DELETE CASCADE,
      UNIQUE KEY unique_user_provider (user_id, provider_id)
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS users_providers")
  end
end
