defmodule DaProductApp.Repo.Migrations.CreateCustomEventLog do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE custom_event_log (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      transaction_id INT  NULL,
      ip_id INT,
      device_id INT,
      event_name VARCHAR(255),
      event_value VARCHAR(255),
      details TEXT,
      date_added DATETIME NOT NULL,
      tracking_id VARCHAR(255),
      event_id INT,
      payload TEXT,
      refrence_id VARCHAR(255), -- <-- Added here
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS custom_event_log")
  end
end
