defmodule DaProductApp.Repo.Migrations.AddFieldsToPosTerminals do
  use Ecto.Migration

  def change do
    alter table(:pos_terminals) do
      add :status, :string, default: "inactive"
      add :activated_by, :string
      add :deactivated_by, :string
      add :assigned_by, :string
      add :longitude, :decimal, precision: 10, scale: 6
      add :latitude, :decimal, precision: 10, scale: 6
      add :assigned_date, :utc_datetime
    end

    create index(:pos_terminals, [:status])
    create index(:pos_terminals, [:assigned_by])
  end
end

