defmodule DaProductApp.Repo.Migrations.CreateShukriaTerminals do
  use Ecto.Migration

  def change do
    create table(:shukria_terminals, primary_key: true) do
      add :shukria_terminal_id, :string, null: false
      add :provider_id, :string, null: false
      add :provider_tid, :string, null: false
      add :provider_mid, :string, null: false
      add :status, :string, default: "active"
      add :description, :string

      timestamps()
    end

    create unique_index(:shukria_terminals, [:shukria_terminal_id])
    create index(:shukria_terminals, [:status])
  end
end

