# Production Deployment Guide for Honoré Bakery Website

## Required Files for Production

The following files need to be uploaded to the production server:

### 1. Core Routing Files
- `index_clean.php` - Front controller for clean URLs
- `.htaccess` - Apache rewrite rules for clean URLs

### 2. Website Pages
- `modern_bakery_homepage.php` - Homepage
- `modern_bakery_about.php` - About page
- `modern_bakery_contact.php` - Contact page
- `modern_bakery_products.php` - Products page
- `modern_bakery_faq.php` - FAQ page
- `modern_bakery_privacy.php` - Privacy Policy
- `modern_bakery_terms.php` - Terms of Service
- `modern_bakery_refund.php` - Refund Policy
- `modern_bakery_shipping.php` - Shipping Policy

### 3. Component Files
- `header_component.php` - Reusable header component
- `modern_footer_component.php` - Reusable footer component
- `cart_component.php` - Shopping cart sidebar component

### 4. Assets (if not already present)
- `assets/` directory with CSS, JS, and images
- Font Awesome icons (CDN or local files)

## Production URL Structure

Based on the production URL: `demo.ctrmv.com/releasepymnstpro/erp-ecom/`

The base path should be: `/releasepymnstpro/erp-ecom`

## Required Changes for Production

### 1. Update Base Path in index_clean.php
Change line 10 from:
```php
$base_path = '/erp-ecom';
```
To:
```php
$base_path = '/releasepymnstpro/erp-ecom';
```

### 2. Update Base Path in All Component Files
In `header_component.php`, `modern_footer_component.php`, and all page files, update all links from:
```php
href="/erp-ecom/"
```
To:
```php
href="/releasepymnstpro/erp-ecom/"
```

### 3. Update .htaccess for Production Path
The .htaccess file should work as-is, but ensure Apache mod_rewrite is enabled.

## Quick Fix Commands

After uploading files, run these commands to update base paths:

```bash
# Update base path in index_clean.php
sed -i 's|/erp-ecom|/releasepymnstpro/erp-ecom|g' index_clean.php

# Update base path in all PHP files
find . -name "*.php" -exec sed -i 's|/erp-ecom/|/releasepymnstpro/erp-ecom/|g' {} \;
```

## Testing Production Setup

1. Upload all required files
2. Update base paths as described above
3. Test the following URLs:
   - `demo.ctrmv.com/releasepymnstpro/erp-ecom/` (homepage)
   - `demo.ctrmv.com/releasepymnstpro/erp-ecom/about`
   - `demo.ctrmv.com/releasepymnstpro/erp-ecom/contact`
   - `demo.ctrmv.com/releasepymnstpro/erp-ecom/products`
   - `demo.ctrmv.com/releasepymnstpro/erp-ecom/faq`

## Troubleshooting

### 404 Errors
- Ensure `.htaccess` file is uploaded
- Check that Apache mod_rewrite is enabled
- Verify file permissions (644 for files, 755 for directories)

### Missing Assets
- Ensure `assets/` directory is uploaded
- Check that Font Awesome CDN is accessible
- Verify image paths are correct

### Base Path Issues
- Double-check all links use `/releasepymnstpro/erp-ecom/` prefix
- Ensure `index_clean.php` has correct base path
- Test with absolute URLs if relative URLs fail
