# Production Deployment Instructions for Honoré Bakery Website

## Quick Fix for 404 Error

The 404 error occurs because the production environment is missing key files and has incorrect base paths.

### Step 1: Upload Required Files

Upload these files to your production server:

**Core Files:**
- `index_clean_production.php` → rename to `index_clean.php`
- `.htaccess_production` → rename to `.htaccess`

**Website Pages:**
- `modern_bakery_homepage.php`
- `modern_bakery_about.php`
- `modern_bakery_contact.php`
- `modern_bakery_products.php`
- `modern_bakery_faq.php`
- `modern_bakery_privacy.php`
- `modern_bakery_terms.php`
- `modern_bakery_refund.php`
- `modern_bakery_shipping.php`

**Component Files:**
- `header_component.php`
- `modern_footer_component.php`
- `cart_component.php`

### Step 2: Update Base Paths

After uploading, you need to update the base paths in all files from `/erp-ecom/` to `/releasepymnstpro/erp-ecom/`.

**Quick Command (if you have SSH access):**
```bash
find . -name "*.php" -exec sed -i 's|/erp-ecom/|/releasepymnstpro/erp-ecom/|g' {} \;
```

**Manual Update (if no SSH access):**
1. Open each PHP file in a text editor
2. Find and replace all instances of `/erp-ecom/` with `/releasepymnstpro/erp-ecom/`
3. Save the file

### Step 3: Test URLs

After deployment, test these URLs:
- `demo.ctrmv.com/releasepymnstpro/erp-ecom/` (homepage)
- `demo.ctrmv.com/releasepymnstpro/erp-ecom/about`
- `demo.ctrmv.com/releasepymnstpro/erp-ecom/contact`
- `demo.ctrmv.com/releasepymnstpro/erp-ecom/products`
- `demo.ctrmv.com/releasepymnstpro/erp-ecom/faq`

### Step 4: Verify Apache Configuration

Ensure your production server has:
- Apache mod_rewrite enabled
- Proper file permissions (644 for files, 755 for directories)
- `.htaccess` files are allowed

### Troubleshooting

**Still getting 404?**
1. Check if `.htaccess` file is uploaded and has correct permissions
2. Verify Apache mod_rewrite is enabled
3. Check server error logs for specific errors
4. Test with direct file access: `demo.ctrmv.com/releasepymnstpro/erp-ecom/modern_bakery_homepage.php`

**Missing assets?**
1. Ensure `assets/` directory is uploaded
2. Check Font Awesome CDN is accessible
3. Verify image paths are correct

**Base path issues?**
1. Double-check all links use `/releasepymnstpro/erp-ecom/` prefix
2. Ensure `index_clean.php` has correct base path
3. Test with absolute URLs if relative URLs fail

## Files Ready for Production

All files have been prepared with the correct production base path `/releasepymnstpro/erp-ecom/`.

The website should work immediately after uploading these files to your production server.
