<?php
// Check Website module status and activate if needed
echo "<h1>Website Module Status Check</h1>";

// Load CodeIgniter
require_once('index.php');

$CI = &get_instance();
$CI->load->database();

echo "<h2>Database Connection Test</h2>";
if ($CI->db->conn_id) {
    echo "<p>✅ Database connection successful</p>";
    
    // Check if modules table exists
    if ($CI->db->table_exists('tblmodules')) {
        echo "<p>✅ Modules table exists</p>";
        
        // Check Website module status
        $CI->db->where('module_name', 'website');
        $query = $CI->db->get('tblmodules');
        
        if ($query->num_rows() > 0) {
            $module = $query->row();
            echo "<p>✅ Website module found in database</p>";
            echo "<p>Status: " . ($module->active ? "ACTIVE" : "INACTIVE") . "</p>";
            echo "<p>Version: " . $module->installed_version . "</p>";
            
            if (!$module->active) {
                echo "<h3>Activating Website Module...</h3>";
                
                // Activate the module
                $CI->db->where('module_name', 'website');
                $CI->db->update('tblmodules', ['active' => 1]);
                
                if ($CI->db->affected_rows() > 0) {
                    echo "<p>✅ Website module activated successfully!</p>";
                } else {
                    echo "<p>❌ Failed to activate Website module</p>";
                }
            } else {
                echo "<p>✅ Website module is already active</p>";
            }
        } else {
            echo "<p>❌ Website module not found in database</p>";
            echo "<h3>Installing Website Module...</h3>";
            
            // Insert the module
            $module_data = [
                'module_name' => 'website',
                'installed_version' => '1.0.0',
                'active' => 1
            ];
            
            if ($CI->db->insert('tblmodules', $module_data)) {
                echo "<p>✅ Website module installed and activated successfully!</p>";
            } else {
                echo "<p>❌ Failed to install Website module</p>";
                echo "<p>Error: " . $CI->db->error()['message'] . "</p>";
            }
        }
    } else {
        echo "<p>❌ Modules table does not exist</p>";
        echo "<p>This might be an older version of the ERP system</p>";
    }
} else {
    echo "<p>❌ Database connection failed</p>";
}

echo "<hr>";
echo "<h2>Test Website Pages</h2>";
echo "<p><a href='index.php' target='_blank'>Test Homepage</a></p>";
echo "<p><a href='about' target='_blank'>Test About Page</a></p>";
echo "<p><a href='contact' target='_blank'>Test Contact Page</a></p>";
echo "<p><a href='products' target='_blank'>Test Products Page</a></p>";

echo "<hr>";
echo "<h2>Module Files Check</h2>";

// Check if module files exist
$module_files = [
    'modules/website/website.php',
    'modules/website/install.php',
    'modules/website/controllers/Website.php',
    'modules/website/models/Website_model.php'
];

foreach ($module_files as $file) {
    if (file_exists($file)) {
        echo "<p>✅ $file exists</p>";
    } else {
        echo "<p>❌ $file missing</p>";
    }
}
?>
