<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Momentpay extends App_Controller
{
	public function redirect($invoice_id, $invoice_hash)
	{
		// Assuming the raw data is stored in $rawData variable
		$rawData = $_REQUEST;

		// Accessing the JSON string value
		$jsonString = $rawData['responseToken'];
		error_log("printing json string".  $jsonString );
		// Decode the JSON string
		$responseToken = json_decode($jsonString, true);

		check_invoice_restrictions($invoice_id, $invoice_hash);

		//		$payment_id         = $this->input->get('payment_id');
		//		$payment_request_id = $this->input->get('payment_request_id');

		if ($responseToken == null) {
			set_alert('warning', 'Payment ID Not Returned via Response');
			redirect(site_url('invoice/' . $invoice_id . '/' . $invoice_hash));
		}

		try {
			//			$api      = $this->momentPay_gateway->createApi();
			//			$response = $api->paymentRequestPaymentStatus($payment_request_id, $payment_id);
			// Check if decoding was successful
			if ($responseToken !== null) {
				// Accessing the decoded JSON data
				$responseCode = $responseToken['response_token']['response_code'];
				$responseMessage = $responseToken['response_token']['response_message'];
				error_log("printing response Toekn". $responseCode . " : ".  $responseMessage);

				if ( $responseCode ==  "1200") {

error_log("printing inside success: " . $responseToken['response_token']['amount'] . " : " . $invoice_id . " : " . (isset($responseToken['response_token']['paymode']) ? $responseToken['response_token']['paymode'] : "CARD") . " : " . $responseToken['response_token']['transaction_id']);

					$success = $this->momentpay_gateway->addPayment(
						[
							'amount'        =>  $responseToken['response_token']['amount'],
							'invoiceid'     => $invoice_id,
							'paymentmethod' => isset($responseToken['response_token']['paymode']) ? $responseToken['response_token']['paymode'] : "CARD",
							'transactionid' => $responseToken['response_token']['transaction_id'],
						]
					);

					set_alert($success
						? 'success' : 'danger', _l($success ? 'online_payment_recorded_success'
						: 'online_payment_recorded_success_fail_database'));
				} else {
					// handle failed payment
					// https://docs.instamojo.com/docs/get-payment-details#response-fields
					//var_dump($response);
					set_alert('danger', _l('invoice_payment_record_failed'));
				}
			}
		} catch (Exception $e) {
			$errors = json_decode($e->getMessage());

			foreach ($errors as $err) {
				set_alert('warning', $err[0]);

				break;
			}
		}

		redirect(site_url('invoice/' . $invoice_id . '/' . $invoice_hash));
	}
}
