<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Momentpay_gateway extends App_gateway
{
    private $sandbox_endpoint = 'https://test.instamojo.com/api/1.1/';

    private $production_endpoint = 'https://www.instamojo.com/api/1.1/';

    public function __construct()
    {
        /**
         * Call App_gateway __construct function
         */
        parent::__construct();
        /**
         * REQUIRED
         * Gateway unique id
         * The ID must be alpha/alphanumeric
         */
        $this->setId('momentpay');

        /**
         * REQUIRED
         * Gateway name
         */
        $this->setName('momentPay');

        /**
         * Add gateway settings
        */
        $this->setSettings(
        [
            [
                'name'      => 'api_key',
                'encrypted' => true,
                'label'     => 'Private API Key',
                ],
            [
                'name'      => 'auth_token',
                'encrypted' => true,
                'label'     => 'Private Auth Token',
                ],
             [
                'name'          => 'description_dashboard',
                'label'         => 'settings_paymentmethod_description',
                'type'          => 'textarea',
                'default_value' => 'Payment for Invoice {invoice_number}',
            ],
            [
                'name'             => 'currencies',
                'label'            => 'settings_paymentmethod_currencies',
                'default_value'    => 'INR,USD',
                ],
            [
                'name'          => 'test_mode_enabled',
                'type'          => 'yes_no',
                'default_value' => 1,
                'label'         => 'settings_paymentmethod_testing_mode',
                ],
            ]
        );
    }

    /**
     * REQUIRED FUNCTION
     * @param  array $data
     * @return mixed
     */
    public function process_payment($data)
    {
        //$gateway = $this->createApi();
	    error_log("process payment");

        try {
            $request = [
                'purpose'      => str_replace('{invoice_number}', format_invoice_number($data['invoice']->id), $this->getSetting('description_dashboard')),
                'amount'       => number_format($data['amount'], 2, '.', ''),
                'redirect_url' => site_url('gateways/momentpay/redirect/' . $data['invoice']->id . '/' . $data['invoice']->hash),
		'dataid' => $data['invoice']->id ,
                ];
	    error_log("process payment". print_r( $request, true));

            $buyer_name  = null;
            $email       = null;
            $phonenumber = null;

            if (is_client_logged_in()) {
                $contact    = $this->ci->clients_model->get_contact(get_contact_user_id());
                $buyer_name = $contact->firstname . ' ' . $contact->lastname;
                if ($contact->email) {
                    $email = $contact->email;
                }
                if ($contact->phonenumber) {
                    $phonenumber = $contact->phonenumber;
                }
            } else {
                $contacts = $this->ci->clients_model->get_contacts($data['invoice']->clientid);
                if (count($contacts) == 1) {
                    $contact    = $contacts[0];
                    $buyer_name = $contact['firstname'] . ' ' . $contact['lastname'];
                    if ($contact['email']) {
                        $email = $contact['email'];
                    }
                    if ($contact['phonenumber']) {
                        $phonenumber = $contact['phonenumber'];
                    }
                }
            }

            $request['buyer_name'] = $buyer_name;
            $request['email']      = $email;
            $request['phone']      = $phonenumber;

            $response = $this->paymentRequestCreate($request);
            redirect($response['checkout_url']);
            die;
        } catch (Exception $e) {
            $errors = json_decode($e->getMessage());

            if (is_array($errors)) {
                foreach ($errors as $err) {
                    set_alert('warning', $err[0]);

                    break;
                }
            } else {
                set_alert('warning', $errors);
            }

            redirect(site_url('invoice/' . $data['invoice']->id . '/' . $data['invoice']->hash));
        }
    }

    public function createApi()
    {
        return new \Instamojo\Instamojo(
            $this->decryptSetting('api_key'),
            $this->decryptSetting('auth_token'),
            $this->getEndpoint()
        );
    }

    private function getEndpoint()
    {
        return $this->getSetting('test_mode_enabled') == '1' ? $this->sandbox_endpoint : $this->production_endpoint;
    }
    public function paymentRequestCreate($requestData)
{
    error_log("Payment Request Data");

    $curl = curl_init();

    // Prepare POST fields including data from $requestData
    $postData = array(
        'private_key' => 'iWsxBWVo2nb62n9NKkf9ChQw8k4zEJv5p7LIWpwxvpJLTsAKc5',
        'currency' => 'INR',
        'is_fallback' => '1',
        'is_test' => '0',
        'amount' => $requestData['amount'],
        'fallback_url' => $requestData['redirect_url'],
	'transaction_id' => $requestData['dataid'].'_'.rand(0000001,9999999),
        'purpose' =>  $requestData['purpose']
    );

    error_log("Post Data:". print_r( $postData, true));
    // Merge additional data from $requestData
//    $postData = array_merge($postData, $requestData);

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'http://demo.ctrmv.com/payment/api/request',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => http_build_query($postData), // Encode POST fields
        CURLOPT_SSL_VERIFYHOST => 0, // Ignore SSL certificate verification
        CURLOPT_SSL_VERIFYPEER => 0, // Ignore SSL certificate verification
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Content-Type: application/x-www-form-urlencoded', // Use appropriate content type
            'Cookie: mailpoet_page_view=%7B%22timestamp%22%3A1695992593%7D'
        ),
    ));

    $response = curl_exec($curl);
    error_log("Response: " . $response);

    curl_close($curl);
    return json_decode($response, true);
}

}
