<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_306 extends CI_Migration
{
    public function up()
    {
        // Check if company_discount column exists and rename it to customer_discount
        if ($this->db->field_exists('company_discount', db_prefix() . 'clients')) {
            $this->db->query('ALTER TABLE `' . db_prefix() . 'clients` CHANGE `company_discount` `customer_discount` VARCHAR(255) DEFAULT NULL');
        } elseif (!$this->db->field_exists('customer_discount', db_prefix() . 'clients')) {
            // If company_discount doesn't exist, and customer_discount also doesn't, then add it.
            $this->db->query('ALTER TABLE `' . db_prefix() . 'clients` ADD `customer_discount` VARCHAR(255) DEFAULT NULL');
        }
    }
}
