<?php $this->load->view('frontend/includes/header'); ?>

    <!-- Page Content -->
    <div class="page-content">
        <div class="container">
            <h1 class="page-title font-playfair">About Honoré Bakery</h1>
            
            <div class="content-section">
                <div class="row">
                    <div class="col-lg-8">
                        <h2 class="font-playfair">Our Story</h2>
                        <p class="lead">Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades.</p>
                        
                        <p>Our journey began when Master Baker Pierre Honoré immigrated from France with a dream to bring the authentic taste of French patisserie to America. Starting as a small family business in a modest kitchen, we have grown into a beloved neighborhood institution while maintaining our commitment to traditional techniques and the finest ingredients.</p>
                        
                        <p>Every morning before dawn, our bakers begin their work, kneading dough by hand and using time-honored methods passed down through generations. We believe that great bread comes from great ingredients, time, and patience – never from shortcuts or artificial additives.</p>
                        
                        <h3 class="font-playfair mt-4">Our Philosophy</h3>
                        <p>At Honoré Bakery, we believe that baking is an art form that connects us to our heritage and brings joy to our community. Our philosophy is simple:</p>
                        <ul>
                            <li><strong>Quality First:</strong> We use only the finest, locally-sourced organic ingredients</li>
                            <li><strong>Traditional Methods:</strong> Our techniques have been perfected over generations</li>
                            <li><strong>Daily Freshness:</strong> Everything is baked fresh every morning</li>
                            <li><strong>Community Focus:</strong> We're proud to be part of the local community</li>
                        </ul>
                    </div>
                    <div class="col-lg-4 text-center">
                        <i class="fas fa-store" style="font-size: 12rem; color: var(--primary-color); opacity: 0.7;"></i>
                    </div>
                </div>
            </div>
            
            <!-- Statistics Section -->
            <div class="stats-section">
                <div class="container">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="stat-item">
                                <div class="stat-number">35+</div>
                                <div class="stat-label">Years of Excellence</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-item">
                                <div class="stat-number">10,000+</div>
                                <div class="stat-label">Happy Customers</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-item">
                                <div class="stat-number">50+</div>
                                <div class="stat-label">Daily Products</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="stat-item">
                                <div class="stat-number">100%</div>
                                <div class="stat-label">Made with Love</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Team Section -->
            <div class="content-section">
                <h2 class="font-playfair text-center mb-5">Meet Our Master Bakers</h2>
                <div class="row">
                    <div class="col-lg-4">
                        <div class="team-member">
                            <div style="width: 200px; height: 200px; background: var(--accent-color); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user" style="font-size: 4rem; color: white;"></i>
                            </div>
                            <h4>Pierre Honoré</h4>
                            <p class="text-muted">Master Baker & Founder</p>
                            <p>With over 40 years of experience, Pierre brings authentic French techniques to every loaf of bread and every delicate pastry.</p>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="team-member">
                            <div style="width: 200px; height: 200px; background: var(--accent-color); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user" style="font-size: 4rem; color: white;"></i>
                            </div>
                            <h4>Marie Dubois</h4>
                            <p class="text-muted">Head Pastry Chef</p>
                            <p>Marie specializes in delicate pastries and custom cakes, bringing artistic flair to every creation that leaves our kitchen.</p>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="team-member">
                            <div style="width: 200px; height: 200px; background: var(--accent-color); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user" style="font-size: 4rem; color: white;"></i>
                            </div>
                            <h4>Jean-Luc Martin</h4>
                            <p class="text-muted">Sourdough Specialist</p>
                            <p>Jean-Luc has perfected our signature sourdough recipe, maintaining the same starter culture for over 20 years.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .page-content {
            padding: 100px 0 60px;
            min-height: 80vh;
        }
        
        .page-title {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .content-section {
            background: white;
            padding: 60px 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 40px;
        }
        
        .team-member {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .team-member img {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 20px;
            border: 5px solid var(--accent-color);
        }
        
        .stats-section {
            background: var(--primary-color);
            color: white;
            padding: 60px 0;
            margin: 40px 0;
        }
        
        .stat-item {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: bold;
            color: var(--accent-color);
        }
        
        .stat-label {
            font-size: 1.2rem;
            margin-top: 10px;
        }
    </style>

<?php $this->load->view('frontend/includes/footer'); ?>
