<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($title) ? $title : 'Contact Us - Honoré Bakery'; ?></title>
    <meta name="description" content="Get in touch with Honoré Bakery. Visit our location, call us, or send us a message. We'd love to hear from you!">
    <meta name="keywords" content="contact us, bakery location, phone number, email, visit us, Honoré Bakery">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Open+Sans:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
            --bg-cream: #FDF5E6;
        }
        
        body {
            font-family: 'Open Sans', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }
        
        .font-playfair {
            font-family: 'Playfair Display', serif;
        }
        
        .navbar-custom {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }
        
        .navbar-brand {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-color) !important;
        }
        
        .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }
        
        .nav-link:hover,
        .nav-link.active {
            color: var(--primary-color) !important;
        }
        
        .hero-contact {
            background: linear-gradient(135deg, #f8f4e6 0%, #e8dcc0 50%, #d4c4a8 100%);
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero-contact::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="%23D2691E" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="%23D2691E" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-contact-content {
            position: relative;
            z-index: 2;
        }
        
        .hero-contact-title {
            font-size: 4rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        
        .hero-contact-subtitle {
            font-size: 1.5rem;
            color: var(--text-light);
            margin-bottom: 2rem;
        }
        
        .section-padding {
            padding: 80px 0;
        }
        
        .contact-card {
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.1);
            margin-bottom: 40px;
            position: relative;
            overflow: hidden;
        }
        
        .contact-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
        }
        
        .contact-info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 50px;
        }
        
        .contact-info-card {
            background: white;
            border-radius: 15px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .contact-info-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .contact-info-card:hover::before {
            transform: scaleX(1);
        }
        
        .contact-info-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }
        
        .contact-icon {
            font-size: 4rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: block;
        }
        
        .contact-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .contact-description {
            color: var(--text-light);
            line-height: 1.7;
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 15px 20px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(139, 69, 19, 0.25);
        }
        
        .btn-primary-custom {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            border: none;
            color: white;
            padding: 15px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(139, 69, 19, 0.3);
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(139, 69, 19, 0.4);
            color: white;
        }
        
        .map-container {
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 40px rgba(0,0,0,0.1);
            margin-top: 40px;
        }
        
        .map-placeholder {
            height: 400px;
            background: linear-gradient(135deg, var(--bg-light) 0%, var(--bg-cream) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text-light);
            font-size: 1.2rem;
        }
        
        .hours-section {
            background: var(--bg-light);
            position: relative;
        }
        
        .hours-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="dots" width="20" height="20" patternUnits="userSpaceOnUse"><circle cx="10" cy="10" r="1" fill="%23D2691E" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23dots)"/></svg>');
            opacity: 0.5;
        }
        
        .hours-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.1);
            position: relative;
            z-index: 2;
        }
        
        .hours-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .hours-item:last-child {
            border-bottom: none;
        }
        
        .day {
            font-weight: 600;
            color: var(--primary-color);
            font-size: 1.1rem;
        }
        
        .time {
            color: var(--text-light);
            font-size: 1.1rem;
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer h5 {
            color: var(--accent-color);
            margin-bottom: 20px;
        }
        
        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer a:hover {
            color: var(--accent-color);
        }
        
        @media (max-width: 768px) {
            .hero-contact-title {
                font-size: 2.5rem;
            }
            
            .contact-card {
                padding: 30px 20px;
            }
            
            .contact-info-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?php echo base_url(); ?>">Honoré Bakery</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url(); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('products'); ?>">Products</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('about'); ?>">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo base_url('contact'); ?>">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-contact">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-contact-content">
                        <h1 class="hero-contact-title font-playfair">Get In Touch</h1>
                        <p class="hero-contact-subtitle">We'd love to hear from you! Visit us, call us, or send us a message.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <i class="fas fa-envelope" style="font-size: 12rem; color: var(--primary-color); opacity: 0.7;"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Form Section -->
    <section class="section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="contact-card">
                        <h2 class="font-playfair mb-4" style="color: var(--primary-color);">Send Us a Message</h2>
                        <form>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="firstName" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="firstName" placeholder="Your first name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="lastName" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="lastName" placeholder="Your last name">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email Address</label>
                                        <input type="email" class="form-control" id="email" placeholder="your.email@example.com">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="phone" class="form-label">Phone Number</label>
                                        <input type="tel" class="form-control" id="phone" placeholder="(555) 123-4567">
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="subject" class="form-label">Subject</label>
                                <input type="text" class="form-control" id="subject" placeholder="What can we help you with?">
                            </div>
                            <div class="mb-3">
                                <label for="message" class="form-label">Message</label>
                                <textarea class="form-control" id="message" rows="5" placeholder="Tell us more about your inquiry..."></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary-custom">
                                <i class="fas fa-paper-plane me-2"></i>Send Message
                            </button>
                        </form>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-info-grid">
                        <div class="contact-info-card">
                            <i class="fas fa-phone contact-icon"></i>
                            <h3 class="contact-title">Call Us</h3>
                            <p class="contact-description">
                                (555) 123-BAKE<br>
                                (555) 123-2253<br>
                                <small>Mon-Fri: 6AM-8PM</small>
                            </p>
                        </div>
                        <div class="contact-info-card">
                            <i class="fas fa-envelope contact-icon"></i>
                            <h3 class="contact-title">Email Us</h3>
                            <p class="contact-description">
                                hello@honorebakery.com<br>
                                orders@honorebakery.com<br>
                                <small>We respond within 24 hours</small>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Additional Contact Info Row -->
            <div class="row mt-4">
                <div class="col-lg-6">
                    <div class="contact-info-card">
                        <i class="fas fa-map-marker-alt contact-icon"></i>
                        <h3 class="contact-title">Visit Us</h3>
                        <p class="contact-description">
                            123 Baker Street<br>
                            Downtown District<br>
                            City, State 12345
                        </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="contact-info-card">
                        <i class="fas fa-clock contact-icon"></i>
                        <h3 class="contact-title">Business Hours</h3>
                        <p class="contact-description">
                            Mon-Fri: 6:00 AM - 8:00 PM<br>
                            Saturday: 7:00 AM - 7:00 PM<br>
                            Sunday: 8:00 AM - 6:00 PM
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="section-padding" style="background: var(--bg-light);">
        <div class="container">
            <h2 class="text-center font-playfair mb-5" style="color: var(--primary-color); font-size: 3rem;">Find Us</h2>
            <div class="map-container">
                <div class="map-placeholder">
                    <div class="text-center">
                        <i class="fas fa-map-marked-alt" style="font-size: 4rem; color: var(--primary-color); margin-bottom: 20px; display: block;"></i>
                        <h4 style="color: var(--primary-color); margin-bottom: 10px;">Interactive Map</h4>
                        <p>123 Baker Street, Downtown District<br>City, State 12345</p>
                        <a href="https://maps.google.com" target="_blank" class="btn btn-primary-custom mt-3">
                            <i class="fas fa-external-link-alt me-2"></i>Open in Google Maps
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Hours Section -->
    <section class="section-padding hours-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hours-card">
                        <h2 class="text-center font-playfair mb-5" style="color: var(--primary-color);">Store Hours</h2>
                        <div class="hours-item">
                            <span class="day">Monday - Friday</span>
                            <span class="time">6:00 AM - 8:00 PM</span>
                        </div>
                        <div class="hours-item">
                            <span class="day">Saturday</span>
                            <span class="time">7:00 AM - 7:00 PM</span>
                        </div>
                        <div class="hours-item">
                            <span class="day">Sunday</span>
                            <span class="time">8:00 AM - 6:00 PM</span>
                        </div>
                        <div class="hours-item">
                            <span class="day">Holidays</span>
                            <span class="time">Call for special hours</span>
                        </div>
                        <div class="text-center mt-4">
                            <p class="text-muted">
                                <i class="fas fa-info-circle me-2"></i>
                                We're closed on major holidays. Please call ahead during holiday seasons.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h5>Honoré Bakery</h5>
                    <p>Fresh artisan breads and pastries made daily with love and tradition.</p>
                    <div class="social-links">
                        <a href="#" class="me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-twitter"></i></a>
                    </div>
                </div>
                <div class="col-lg-2">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li><a href="<?php echo base_url('products'); ?>">Products</a></li>
                        <li><a href="<?php echo base_url('about'); ?>">About</a></li>
                        <li><a href="<?php echo base_url('contact'); ?>">Contact</a></li>
                    </ul>
                </div>
                <div class="col-lg-3">
                    <h5>Products</h5>
                    <ul class="list-unstyled">
                        <li><a href="#">Breads</a></li>
                        <li><a href="#">Pastries</a></li>
                        <li><a href="#">Cakes</a></li>
                        <li><a href="#">Coffee</a></li>
                    </ul>
                </div>
                <div class="col-lg-3">
                    <h5>Contact Info</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i> 123 Baker Street</p>
                    <p><i class="fas fa-phone me-2"></i> (555) 123-BAKE</p>
                    <p><i class="fas fa-envelope me-2"></i> hello@honorebakery.com</p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-12 text-center">
                    <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add scroll effect to navbar
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.background = 'rgba(255, 255, 255, 0.98)';
            } else {
                navbar.style.background = 'rgba(255, 255, 255, 0.95)';
            }
        });

        // Form submission handling
        document.querySelector('form').addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Thank you for your message! We\'ll get back to you within 24 hours.');
        });
    </script>
</body>
</html>
