<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title : 'Honoré Bakery - Fresh Artisan Breads & Pastries'; ?></title>
    <meta name="description" content="Honoré Bakery - Fresh artisan breads, pastries, and cakes made daily with love. Visit our bakery for the finest baked goods in town.">
    <meta name="keywords" content="bakery, fresh bread, pastries, cakes, artisan, Honoré, bakery shop">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Open+Sans:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
            --bg-cream: #FDF5E6;
        }
        
        body {
            font-family: 'Open Sans', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }
        
        .font-playfair {
            font-family: 'Playfair Display', serif;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f4e6 0%, #e8dcc0 50%, #d4c4a8 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero-background {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="%23D2691E" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="%23D2691E" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="%23D2691E" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="%23D2691E" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="%23D2691E" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-particles {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 80%, rgba(139, 69, 19, 0.1) 0%, transparent 50%),
                        radial-gradient(circle at 80% 20%, rgba(210, 105, 30, 0.1) 0%, transparent 50%),
                        radial-gradient(circle at 40% 40%, rgba(244, 164, 96, 0.1) 0%, transparent 50%);
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .hero-badge {
            display: inline-block;
            background: rgba(255, 255, 255, 0.9);
            color: var(--primary-color);
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .hero-title {
            font-size: 4.5rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            line-height: 1.1;
        }
        
        .hero-title-main {
            color: var(--primary-color);
            display: block;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        
        .hero-title-accent {
            color: var(--secondary-color);
            display: block;
            background: linear-gradient(45deg, var(--secondary-color), var(--accent-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .hero-subtitle {
            font-size: 1.3rem;
            color: var(--text-light);
            margin-bottom: 2.5rem;
            line-height: 1.6;
        }
        
        .hero-stats {
            display: flex;
            gap: 30px;
            margin-bottom: 2.5rem;
        }
        
        .stat-item {
            text-align: center;
        }
        
        .stat-number {
            display: block;
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-color);
            line-height: 1;
        }
        
        .stat-label {
            font-size: 0.9rem;
            color: var(--text-light);
            font-weight: 500;
        }
        
        .hero-image-container {
            position: relative;
            height: 500px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .hero-image-main {
            font-size: 15rem;
            color: var(--primary-color);
            opacity: 0.8;
            animation: pulse 2s ease-in-out infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        .hero-floating-elements {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
        }
        
        .floating-element {
            position: absolute;
            font-size: 3rem;
            color: var(--accent-color);
            opacity: 0.7;
            animation: floatElement 3s ease-in-out infinite;
        }
        
        .element-1 {
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }
        
        .element-2 {
            top: 60%;
            right: 15%;
            animation-delay: 1s;
        }
        
        .element-3 {
            bottom: 20%;
            left: 20%;
            animation-delay: 2s;
        }
        
        @keyframes floatElement {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-15px) rotate(10deg); }
        }
        
        .hero-scroll-indicator {
            position: absolute;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            color: var(--primary-color);
            font-size: 1.5rem;
            animation: bounce 2s infinite;
        }
        
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateX(-50%) translateY(0); }
            40% { transform: translateX(-50%) translateY(-10px); }
            60% { transform: translateX(-50%) translateY(-5px); }
        }
        
        .hero-secondary {
            background: linear-gradient(135deg, #fff 0%, #f8f4e6 100%);
            padding: 80px 0;
            position: relative;
        }
        
        .hero-secondary::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="dots" width="20" height="20" patternUnits="userSpaceOnUse"><circle cx="10" cy="10" r="1" fill="%23D2691E" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23dots)"/></svg>');
            opacity: 0.5;
        }
        
        .hero-secondary-content {
            position: relative;
            z-index: 2;
        }
        
        .hero-secondary-title {
            font-size: 1.2rem;
            color: var(--accent-color);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 10px;
        }
        
        .hero-secondary-subtitle {
            font-size: 3rem;
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .hero-secondary-text {
            font-size: 1.1rem;
            color: var(--text-light);
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .hero-secondary-price {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .price-original {
            font-size: 1.2rem;
            color: #999;
            text-decoration: line-through;
        }
        
        .price-sale {
            font-size: 2rem;
            font-weight: 700;
            color: var(--secondary-color);
        }
        
        .price-badge {
            background: #ff4444;
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .hero-secondary-image {
            position: relative;
            text-align: center;
        }
        
        .image-placeholder {
            width: 300px;
            height: 300px;
            background: linear-gradient(45deg, var(--bg-light), var(--bg-cream));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8rem;
            color: var(--primary-color);
            margin: 0 auto;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            position: relative;
        }
        
        .image-badge {
            position: absolute;
            top: 20px;
            right: 20px;
            background: var(--secondary-color);
            color: white;
            padding: 8px 15px;
            border-radius: 25px;
            font-size: 0.9rem;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(210, 105, 30, 0.3);
        }
        
        .btn-secondary-custom {
            background: linear-gradient(45deg, var(--secondary-color), var(--accent-color));
            border: none;
            color: white;
            padding: 15px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(210, 105, 30, 0.3);
        }
        
        .btn-secondary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(210, 105, 30, 0.4);
            color: white;
        }
        
        .hero-process {
            background: linear-gradient(135deg, #fff 0%, #f8f4e6 100%);
            padding: 100px 0;
            position: relative;
            overflow: hidden;
        }
        
        .hero-process::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="waves" width="100" height="100" patternUnits="userSpaceOnUse"><path d="M0,50 Q25,0 50,50 T100,50 L100,100 L0,100 Z" fill="%23D2691E" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23waves)"/></svg>');
            opacity: 0.3;
        }
        
        .process-image {
            position: relative;
            height: 400px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .process-step {
            position: absolute;
            width: 120px;
            height: 120px;
            background: white;
            border-radius: 50%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            animation: processFloat 4s ease-in-out infinite;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .process-step:hover {
            transform: scale(1.1);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        }
        
        .process-step i {
            font-size: 2rem;
            color: var(--primary-color);
            margin-bottom: 8px;
        }
        
        .process-step span {
            font-size: 0.8rem;
            font-weight: 600;
            color: var(--text-dark);
            text-align: center;
        }
        
        .step-1 {
            top: 20%;
            left: 20%;
            animation-delay: 0s;
        }
        
        .step-2 {
            top: 20%;
            right: 20%;
            animation-delay: 1s;
        }
        
        .step-3 {
            bottom: 20%;
            left: 20%;
            animation-delay: 2s;
        }
        
        .step-4 {
            bottom: 20%;
            right: 20%;
            animation-delay: 3s;
        }
        
        @keyframes processFloat {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(5deg); }
        }
        
        .process-content {
            position: relative;
            z-index: 2;
        }
        
        .process-title {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .process-text {
            font-size: 1.1rem;
            color: var(--text-light);
            margin-bottom: 30px;
            line-height: 1.7;
        }
        
        .process-features {
            margin-bottom: 30px;
        }
        
        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            font-size: 1rem;
            color: var(--text-dark);
        }
        
        .feature-item i {
            color: var(--secondary-color);
            margin-right: 12px;
            font-size: 1.2rem;
        }
        
        .section-header {
            margin-bottom: 60px;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: var(--text-light);
            margin-bottom: 20px;
        }
        
        .section-divider {
            width: 100px;
            height: 3px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            margin: 0 auto;
            border-radius: 2px;
        }
        
        .btn-primary-custom {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            border: none;
            padding: 15px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(139, 69, 19, 0.3);
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(139, 69, 19, 0.4);
        }
        
        .section-padding {
            padding: 80px 0;
        }
        
        .section-title {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-color);
            text-align: center;
            margin-bottom: 3rem;
            position: relative;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            border-radius: 2px;
        }
        
        .product-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            transition: all 0.4s ease;
            margin-bottom: 30px;
            position: relative;
            border: 1px solid rgba(139, 69, 19, 0.1);
        }
        
        .product-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .product-card:hover::before {
            transform: scaleX(1);
        }
        
        .product-card:hover {
            transform: translateY(-15px);
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
        }
        
        .product-image {
            height: 280px;
            background: linear-gradient(135deg, #f8f4e6 0%, #e8dcc0 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 5rem;
            color: var(--primary-color);
            position: relative;
            overflow: hidden;
        }
        
        .product-image::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="%23D2691E" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="%23D2691E" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }
        
        .product-image i {
            position: relative;
            z-index: 2;
            transition: all 0.3s ease;
        }
        
        .product-card:hover .product-image i {
            transform: scale(1.1) rotate(5deg);
        }
        
        .product-info {
            padding: 30px;
            position: relative;
        }
        
        .product-badge {
            position: absolute;
            top: -15px;
            right: 20px;
            background: var(--secondary-color);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(210, 105, 30, 0.3);
        }
        
        .product-title {
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 15px;
            line-height: 1.3;
        }
        
        .product-description {
            color: var(--text-light);
            margin-bottom: 20px;
            line-height: 1.6;
            font-size: 0.95rem;
        }
        
        .product-price {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .product-rating {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .product-rating .stars {
            color: #ffc107;
            margin-right: 8px;
        }
        
        .product-rating .rating-text {
            color: var(--text-light);
            font-size: 0.9rem;
        }
        
        .feature-card {
            text-align: center;
            padding: 40px 20px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.12);
        }
        
        .feature-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .testimonial-card {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            text-align: center;
            margin-bottom: 30px;
        }
        
        .testimonial-text {
            font-style: italic;
            font-size: 1.1rem;
            color: var(--text-light);
            margin-bottom: 20px;
        }
        
        .testimonial-author {
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer h5 {
            color: var(--accent-color);
            margin-bottom: 20px;
        }
        
        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer a:hover {
            color: var(--accent-color);
        }
        
        .navbar-custom {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }
        
        .navbar-brand {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-color) !important;
        }
        
        .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }
        
        .nav-link:hover {
            color: var(--primary-color) !important;
        }
        
        .qty_total {
            background: var(--secondary-color);
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.7rem;
            margin-left: 5px;
            min-width: 18px;
            text-align: center;
            display: inline-block;
        }
        
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }
            
            .hero-subtitle {
                font-size: 1.2rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?php echo base_url(); ?>">Honoré Bakery</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo base_url(); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('products'); ?>">Products</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('about'); ?>">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('contact'); ?>">Contact</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo base_url('omni_sales/omni_sales_client/view_overview'); ?>">
                            <i class="fas fa-shopping-cart"></i>
                            <span class="qty_total" id="qty_total">0</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Hero Section -->
    <section id="home" class="hero-section">
        <div class="hero-background">
            <div class="hero-particles"></div>
        </div>
        <div class="container">
            <div class="row align-items-center min-vh-100">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <div class="hero-badge">
                            <i class="fas fa-award me-2"></i>Est. 1985
                        </div>
                        <h1 class="hero-title font-playfair">
                            <span class="hero-title-main">Fresh Artisan</span>
                            <span class="hero-title-accent">Breads & Pastries</span>
                        </h1>
                        <p class="hero-subtitle">Made daily with love, tradition, and the finest ingredients. Experience the authentic taste of French baking in every bite.</p>
                        <div class="hero-stats">
                            <div class="stat-item">
                                <span class="stat-number">35+</span>
                                <span class="stat-label">Years</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">10K+</span>
                                <span class="stat-label">Happy Customers</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">100%</span>
                                <span class="stat-label">Fresh Daily</span>
                            </div>
                        </div>
                        <div class="hero-buttons">
                            <a href="#products" class="btn btn-primary-custom text-white me-3">
                                <i class="fas fa-shopping-cart me-2"></i>Order Now
                            </a>
                            <a href="#about" class="btn btn-outline-primary-custom">
                                <i class="fas fa-play me-2"></i>Watch Story
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <div class="hero-image-container">
                        <div class="hero-image-main">
                            <i class="fas fa-bread-slice"></i>
                        </div>
                        <div class="hero-floating-elements">
                            <div class="floating-element element-1">
                                <i class="fas fa-cookie-bite"></i>
                            </div>
                            <div class="floating-element element-2">
                                <i class="fas fa-birthday-cake"></i>
                            </div>
                            <div class="floating-element element-3">
                                <i class="fas fa-coffee"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="hero-scroll-indicator">
            <i class="fas fa-chevron-down"></i>
        </div>
    </section>

    <!-- Secondary Hero - Featured Today -->
    <section class="hero-secondary">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-secondary-content">
                        <h2 class="hero-secondary-title font-playfair">Today's Special</h2>
                        <h3 class="hero-secondary-subtitle">Chocolate Croissant Deluxe</h3>
                        <p class="hero-secondary-text">Our signature chocolate croissant made with premium Belgian chocolate and flaky, buttery pastry. Limited quantity available daily.</p>
                        <div class="hero-secondary-price">
                            <span class="price-original">$6.99</span>
                            <span class="price-sale">$4.99</span>
                            <span class="price-badge">25% OFF</span>
                        </div>
                        <a href="#products" class="btn btn-secondary-custom">
                            <i class="fas fa-shopping-bag me-2"></i>Order Special
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-secondary-image">
                        <div class="image-placeholder">
                            <i class="fas fa-cookie-bite"></i>
                        </div>
                        <div class="image-badge">
                            <i class="fas fa-fire"></i> Hot & Fresh
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Third Hero - Process Showcase -->
    <section class="hero-process">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="process-image">
                        <div class="process-step step-1">
                            <i class="fas fa-seedling"></i>
                            <span>Fresh Ingredients</span>
                        </div>
                        <div class="process-step step-2">
                            <i class="fas fa-hands"></i>
                            <span>Hand Crafted</span>
                        </div>
                        <div class="process-step step-3">
                            <i class="fas fa-fire"></i>
                            <span>Baked Fresh</span>
                        </div>
                        <div class="process-step step-4">
                            <i class="fas fa-heart"></i>
                            <span>Made with Love</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-content">
                        <h2 class="process-title font-playfair">Our Artisan Process</h2>
                        <p class="process-text">Every morning before dawn, our master bakers begin their craft. From selecting the finest ingredients to the final golden crust, each step is performed with precision and passion.</p>
                        <div class="process-features">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>100% Natural Ingredients</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Traditional French Techniques</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Baked Fresh Every Morning</span>
                            </div>
                        </div>
                        <a href="#about" class="btn btn-outline-primary-custom">
                            <i class="fas fa-play-circle me-2"></i>Watch Our Process
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Products Section -->
    <section id="products" class="section-padding" style="background: var(--bg-light);">
        <div class="container">
            <div class="section-header text-center">
                <h2 class="section-title font-playfair">Our Signature Products</h2>
                <p class="section-subtitle">Handcrafted with love, tradition, and the finest ingredients</p>
                <div class="section-divider"></div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-badge">Best Seller</div>
                        <div class="product-image">
                            <i class="fas fa-bread-slice"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Artisan Sourdough</h3>
                            <p class="product-description">Traditional sourdough bread with a perfect crust and tangy flavor, fermented for 24 hours using our secret starter culture.</p>
                            <div class="product-rating">
                                <div class="stars">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                                <span class="rating-text">(127 reviews)</span>
                            </div>
                            <div class="product-price">$8.99</div>
                            <button class="btn btn-primary-custom text-white w-100">
                                <i class="fas fa-shopping-cart me-2"></i>Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-badge">New</div>
                        <div class="product-image">
                            <i class="fas fa-birthday-cake"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Chocolate Croissants</h3>
                            <p class="product-description">Buttery, flaky croissants filled with rich Belgian chocolate, baked fresh every morning using traditional French techniques.</p>
                            <div class="product-rating">
                                <div class="stars">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                                <span class="rating-text">(89 reviews)</span>
                            </div>
                            <div class="product-price">$4.50</div>
                            <button class="btn btn-primary-custom text-white w-100">
                                <i class="fas fa-shopping-cart me-2"></i>Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-badge">Premium</div>
                        <div class="product-image">
                            <i class="fas fa-cookie-bite"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Macarons Assortment</h3>
                            <p class="product-description">Delicate French macarons in 6 different flavors, perfect for special occasions and elegant gatherings.</p>
                            <div class="product-rating">
                                <div class="stars">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                                <span class="rating-text">(156 reviews)</span>
                            </div>
                            <div class="product-price">$18.99</div>
                            <button class="btn btn-primary-custom text-white w-100">
                                <i class="fas fa-shopping-cart me-2"></i>Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-cookie"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Cinnamon Rolls</h3>
                            <p class="text-muted">Soft, gooey cinnamon rolls with cream cheese frosting, made with our secret recipe.</p>
                            <div class="product-price">$6.99</div>
                            <button class="btn btn-primary-custom text-white w-100">Add to Cart</button>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-birthday-cake"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Custom Cakes</h3>
                            <p class="text-muted">Beautiful custom cakes for birthdays, weddings, and special celebrations.</p>
                            <div class="product-price">From $45</div>
                            <button class="btn btn-primary-custom text-white w-100">Order Custom</button>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-coffee"></i>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title">Fresh Coffee</h3>
                            <p class="text-muted">Premium coffee beans roasted daily, paired perfectly with our baked goods.</p>
                            <div class="product-price">$3.50</div>
                            <button class="btn btn-primary-custom text-white w-100">Add to Cart</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="section-padding">
        <div class="container">
            <h2 class="section-title font-playfair">Why Choose Honoré Bakery?</h2>
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-leaf"></i>
                        </div>
                        <h4>Fresh Ingredients</h4>
                        <p>We use only the finest, locally-sourced organic ingredients in all our products.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <h4>Baked Daily</h4>
                        <p>Everything is baked fresh every morning, ensuring the highest quality and taste.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-heart"></i>
                        </div>
                        <h4>Made with Love</h4>
                        <p>Our family recipes have been passed down for generations, made with passion and care.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="section-padding" style="background: var(--bg-light);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h2 class="section-title font-playfair text-start">Our Story</h2>
                    <p class="lead">Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades.</p>
                    <p>Our master bakers start their day before dawn, kneading dough by hand and using traditional techniques passed down through generations. We believe that great bread comes from great ingredients, time, and patience.</p>
                    <p>From our signature sourdough to delicate pastries, every item in our bakery is crafted with the same attention to detail and love that has made us a beloved part of the community.</p>
                    <div class="row mt-4">
                        <div class="col-6">
                            <h5>35+ Years</h5>
                            <p class="text-muted">of baking excellence</p>
                        </div>
                        <div class="col-6">
                            <h5>10,000+</h5>
                            <p class="text-muted">happy customers</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <i class="fas fa-store" style="font-size: 12rem; color: var(--primary-color); opacity: 0.7;"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section id="testimonials" class="section-padding">
        <div class="container">
            <h2 class="section-title font-playfair">What Our Customers Say</h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "The best croissants in town! I come here every Saturday morning. The quality is consistently amazing."
                        </div>
                        <div class="testimonial-author">- Sarah Johnson</div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "Honoré Bakery made our wedding cake and it was absolutely perfect. Beautiful and delicious!"
                        </div>
                        <div class="testimonial-author">- Michael & Emily</div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "The sourdough bread is incredible. You can taste the tradition and care in every bite."
                        </div>
                        <div class="testimonial-author">- David Chen</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="section-padding" style="background: var(--bg-light);">
        <div class="container">
            <h2 class="section-title font-playfair">Visit Us Today</h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="contact-info">
                        <h4>Location & Hours</h4>
                        <p><i class="fas fa-map-marker-alt me-2"></i> 123 Baker Street, Downtown</p>
                        <p><i class="fas fa-phone me-2"></i> (555) 123-BAKE</p>
                        <p><i class="fas fa-envelope me-2"></i> hello@honorebakery.com</p>
                        <hr>
                        <h5>Store Hours</h5>
                        <p>Monday - Friday: 6:00 AM - 7:00 PM</p>
                        <p>Saturday: 6:00 AM - 8:00 PM</p>
                        <p>Sunday: 7:00 AM - 6:00 PM</p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="contact-form">
                        <h4>Send us a Message</h4>
                        <form>
                            <div class="mb-3">
                                <input type="text" class="form-control" placeholder="Your Name" required>
                            </div>
                            <div class="mb-3">
                                <input type="email" class="form-control" placeholder="Your Email" required>
                            </div>
                            <div class="mb-3">
                                <textarea class="form-control" rows="4" placeholder="Your Message" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary-custom text-white w-100">Send Message</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h5>Honoré Bakery</h5>
                    <p>Fresh artisan breads and pastries made daily with love and tradition.</p>
                    <div class="social-links">
                        <a href="#" class="me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-twitter"></i></a>
                    </div>
                </div>
                <div class="col-lg-2">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="#home">Home</a></li>
                        <li><a href="#products">Products</a></li>
                        <li><a href="#about">About</a></li>
                        <li><a href="#contact">Contact</a></li>
                    </ul>
                </div>
                <div class="col-lg-3">
                    <h5>Products</h5>
                    <ul class="list-unstyled">
                        <li><a href="#">Breads</a></li>
                        <li><a href="#">Pastries</a></li>
                        <li><a href="#">Cakes</a></li>
                        <li><a href="#">Coffee</a></li>
                    </ul>
                </div>
                <div class="col-lg-3">
                    <h5>Contact Info</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i> 123 Baker Street</p>
                    <p><i class="fas fa-phone me-2"></i> (555) 123-BAKE</p>
                    <p><i class="fas fa-envelope me-2"></i> hello@honorebakery.com</p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-12 text-center">
                    <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add scroll effect to navbar
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.background = 'rgba(255, 255, 255, 0.98)';
            } else {
                navbar.style.background = 'rgba(255, 255, 255, 0.95)';
            }
        });
    </script>
</body>
</html>
