<?php $this->load->view('frontend/includes/header'); ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="hero-title font-playfair">Welcome to Honoré Bakery</h1>
                    <p class="hero-subtitle">Fresh artisan breads and pastries made daily with traditional French techniques</p>
                    <div class="hero-buttons">
                        <a href="<?php echo base_url('products'); ?>" class="btn btn-primary-custom btn-lg me-3">View Products</a>
                        <a href="<?php echo base_url('about'); ?>" class="btn btn-outline-light btn-lg">Learn More</a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <i class="fas fa-bread-slice" style="font-size: 15rem; color: var(--accent-color); opacity: 0.8;"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Products Section -->
    <section class="section" style="background: white;">
        <div class="container">
            <h2 class="section-title font-playfair">Featured Products</h2>
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-bread-slice"></i>
                        </div>
                        <h3 class="product-title">Artisan Sourdough</h3>
                        <p class="product-description">Traditional sourdough bread with a perfect crust and tangy flavor</p>
                        <div class="product-price">$8.99</div>
                        <a href="<?php echo base_url('products'); ?>" class="btn btn-primary-custom">Order Now</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-cookie-bite"></i>
                        </div>
                        <h3 class="product-title">French Croissants</h3>
                        <p class="product-description">Buttery, flaky croissants made with premium European butter</p>
                        <div class="product-price">$3.99</div>
                        <a href="<?php echo base_url('products'); ?>" class="btn btn-primary-custom">Order Now</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="product-card">
                        <div class="product-image">
                            <i class="fas fa-birthday-cake"></i>
                        </div>
                        <h3 class="product-title">Custom Cakes</h3>
                        <p class="product-description">Beautiful custom cakes for any special occasion</p>
                        <div class="product-price">From $25.99</div>
                        <a href="<?php echo base_url('contact'); ?>" class="btn btn-primary-custom">Order Now</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="section" style="background: var(--bg-light);">
        <div class="container">
            <h2 class="section-title font-playfair">Why Choose Honoré Bakery?</h2>
            <div class="row">
                <div class="col-lg-4 text-center mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-leaf" style="font-size: 4rem; color: var(--primary-color); margin-bottom: 20px;"></i>
                        <h4>Fresh Ingredients</h4>
                        <p>We use only the finest, locally-sourced organic ingredients in all our products.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-clock" style="font-size: 4rem; color: var(--primary-color); margin-bottom: 20px;"></i>
                        <h4>Daily Fresh</h4>
                        <p>Everything is baked fresh every morning using traditional French techniques.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-heart" style="font-size: 4rem; color: var(--primary-color); margin-bottom: 20px;"></i>
                        <h4>Made with Love</h4>
                        <p>Every product is crafted with passion and attention to detail by our master bakers.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="section" style="background: white;">
        <div class="container">
            <h2 class="section-title font-playfair">What Our Customers Say</h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "The best bakery in town! Their sourdough bread is absolutely amazing. I come here every week."
                        </div>
                        <div class="testimonial-author">- Sarah Johnson</div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "Honoré Bakery's croissants are like being in Paris! Perfect texture and flavor every time."
                        </div>
                        <div class="testimonial-author">- Michael Chen</div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="testimonial-card">
                        <div class="testimonial-text">
                            "They made the most beautiful wedding cake for us. Highly recommend for special occasions!"
                        </div>
                        <div class="testimonial-author">- Emily & David</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact CTA Section -->
    <section class="section" style="background: var(--primary-color); color: white;">
        <div class="container text-center">
            <h2 class="font-playfair" style="color: white; margin-bottom: 2rem;">Ready to Taste the Difference?</h2>
            <p class="lead mb-4">Visit our bakery today and experience the authentic taste of French baking!</p>
            <a href="<?php echo base_url('contact'); ?>" class="btn btn-primary-custom btn-lg">Visit Us Today</a>
        </div>
    </section>

    <style>
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero-title {
            font-size: 4rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
        }
        
        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }
        
        .btn-primary-custom {
            background: var(--accent-color);
            border: none;
            color: var(--text-dark);
            padding: 15px 30px;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .section {
            padding: 80px 0;
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 3rem;
            text-align: center;
        }
        
        .product-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
            height: 100%;
        }
        
        .product-card:hover {
            transform: translateY(-10px);
        }
        
        .product-image {
            width: 100%;
            height: 200px;
            background: var(--bg-cream);
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 4rem;
            color: var(--primary-color);
        }
        
        .product-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .product-price {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 15px;
        }
        
        .testimonial-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        
        .testimonial-text {
            font-style: italic;
            font-size: 1.1rem;
            margin-bottom: 20px;
            color: var(--text-light);
        }
        
        .testimonial-author {
            font-weight: 600;
            color: var(--primary-color);
        }
    </style>

<?php $this->load->view('frontend/includes/footer'); ?>
