<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .content h2 {
            color: var(--primary-color);
            font-size: 2.5rem;
            margin-bottom: 30px;
        }
        
        .content p {
            font-size: 1.1rem;
            margin-bottom: 20px;
            color: var(--text-light);
        }
        
        .stats {
            background: var(--primary-color);
            color: white;
            padding: 60px 0;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            text-align: center;
        }
        
        .stat-item h3 {
            font-size: 3rem;
            margin-bottom: 10px;
            color: var(--accent-color);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="bakery_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="bakery_homepage.php">Home</a></li>
                <li><a href="bakery_about.php">About</a></li>
                <li><a href="bakery_contact.php">Contact</a></li>
                <li><a href="bakery_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>About Honoré Bakery</h1>
            <p>Founded in 1985, serving authentic French baking traditions</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <h2>Our Story</h2>
            <p>Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades. Our journey began when Master Baker Pierre Honoré immigrated from France with a dream to bring the authentic taste of French patisserie to America.</p>
            
            <p>Starting as a small family business in a modest kitchen, we have grown into a beloved neighborhood institution while maintaining our commitment to traditional techniques and the finest ingredients.</p>
            
            <p>Every morning before dawn, our bakers begin their work, kneading dough by hand and using time-honored methods passed down through generations. We believe that great bread comes from great ingredients, time, and patience – never from shortcuts or artificial additives.</p>
            
            <h2>Our Philosophy</h2>
            <ul style="font-size: 1.1rem; color: var(--text-light); margin-left: 20px;">
                <li><strong>Quality First:</strong> We use only the finest, locally-sourced organic ingredients</li>
                <li><strong>Traditional Methods:</strong> Our techniques have been perfected over generations</li>
                <li><strong>Daily Freshness:</strong> Everything is baked fresh every morning</li>
                <li><strong>Community Focus:</strong> We're proud to be part of the local community</li>
            </ul>
            
            <h2>Meet Our Team</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-top: 30px;">
                <div style="background: #f9f9f9; padding: 30px; border-radius: 15px; text-align: center;">
                    <h4 style="color: var(--primary-color); margin-bottom: 10px;">Pierre Honoré</h4>
                    <p style="color: var(--secondary-color); font-weight: 600; margin-bottom: 15px;">Master Baker & Founder</p>
                    <p>With over 40 years of experience, Pierre brings authentic French techniques to every loaf of bread and every delicate pastry.</p>
                </div>
                <div style="background: #f9f9f9; padding: 30px; border-radius: 15px; text-align: center;">
                    <h4 style="color: var(--primary-color); margin-bottom: 10px;">Marie Dubois</h4>
                    <p style="color: var(--secondary-color); font-weight: 600; margin-bottom: 15px;">Head Pastry Chef</p>
                    <p>Marie specializes in delicate pastries and custom cakes, bringing artistic flair to every creation that leaves our kitchen.</p>
                </div>
                <div style="background: #f9f9f9; padding: 30px; border-radius: 15px; text-align: center;">
                    <h4 style="color: var(--primary-color); margin-bottom: 10px;">Jean-Luc Martin</h4>
                    <p style="color: var(--secondary-color); font-weight: 600; margin-bottom: 15px;">Sourdough Specialist</p>
                    <p>Jean-Luc has perfected our signature sourdough recipe, maintaining the same starter culture for over 20 years.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="stats">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-item">
                    <h3>35+</h3>
                    <p>Years of Excellence</p>
                </div>
                <div class="stat-item">
                    <h3>10,000+</h3>
                    <p>Happy Customers</p>
                </div>
                <div class="stat-item">
                    <h3>50+</h3>
                    <p>Daily Products</p>
                </div>
                <div class="stat-item">
                    <h3>100%</h3>
                    <p>Made with Love</p>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>