<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Honoré Bakery - Fresh Artisan Breads & Pastries</title>
    <meta name="description" content="Honoré Bakery offers fresh artisan breads, pastries, and baked goods made daily with traditional French techniques.">
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .hero {
            background: linear-gradient(135deg, #f8f4e6 0%, #e8dcc0 100%);
            padding: 120px 0 80px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Cdefs%3E%3Cpattern id='grain' width='100' height='100' patternUnits='userSpaceOnUse'%3E%3Ccircle cx='25' cy='25' r='1' fill='%23D2691E' opacity='0.1'/%3E%3Ccircle cx='75' cy='75' r='1' fill='%23D2691E' opacity='0.1'/%3E%3C/pattern%3E%3C/defs%3E%3Crect width='100' height='100' fill='url(%23grain)'/%3E%3C/svg%3E");
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .hero h1 {
            font-size: 4.5rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        
        .hero p {
            font-size: 1.3rem;
            color: var(--text-light);
            margin-bottom: 30px;
        }
        
        .btn {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(139, 69, 19, 0.3);
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(139, 69, 19, 0.4);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .section {
            padding: 80px 0;
        }
        
        .products {
            background: white;
        }
        
        .section-title {
            font-size: 3rem;
            color: var(--primary-color);
            text-align: center;
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        .section-subtitle {
            text-align: center;
            font-size: 1.2rem;
            color: var(--text-light);
            margin-bottom: 40px;
        }
        
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .product-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            text-align: center;
            transition: all 0.3s;
            border: 1px solid rgba(139, 69, 19, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        .product-card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            transform: scaleX(0);
            transition: transform 0.3s;
        }
        
        .product-card:hover::before {
            transform: scaleX(1);
        }
        
        .product-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
        }
        
        .product-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .product-title {
            font-size: 1.6rem;
            color: var(--primary-color);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .product-description {
            color: var(--text-light);
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .product-price {
            font-size: 1.8rem;
            color: var(--secondary-color);
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .features {
            background: var(--bg-light);
        }
        
        .feature-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .feature-card {
            background: white;
            padding: 40px 20px;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            transition: all 0.3s;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.12);
        }
        
        .feature-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 40px;
        }
        
        .footer h5 {
            color: var(--accent-color);
            margin-bottom: 20px;
            font-size: 1.2rem;
        }
        
        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer a:hover {
            color: var(--accent-color);
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.2);
        }
        
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .nav-links {
                flex-direction: column;
            }
            
            .nav-links li {
                margin: 10px 0;
            }
            
            .section-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="bakery_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="bakery_homepage.php">Home</a></li>
                <li><a href="bakery_about.php">About</a></li>
                <li><a href="bakery_contact.php">Contact</a></li>
                <li><a href="bakery_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Fresh Artisan Breads & Pastries</h1>
                <p>Made daily with love, tradition, and the finest ingredients. Experience the authentic taste of French baking in every bite.</p>
                <a href="bakery_products.php" class="btn">Order Now</a>
            </div>
        </div>
    </section>

    <section class="section products">
        <div class="container">
            <h2 class="section-title">Our Signature Products</h2>
            <p class="section-subtitle">Handcrafted with love, tradition, and the finest ingredients</p>
            
            <div class="product-grid">
                <div class="product-card">
                    <div class="product-icon">🍞</div>
                    <h3 class="product-title">Artisan Sourdough</h3>
                    <p class="product-description">Traditional sourdough bread with a perfect crust and tangy flavor, fermented for 24 hours using our secret starter culture.</p>
                    <div class="product-price">$8.99</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🥐</div>
                    <h3 class="product-title">Chocolate Croissants</h3>
                    <p class="product-description">Buttery, flaky croissants filled with rich Belgian chocolate, baked fresh every morning using traditional French techniques.</p>
                    <div class="product-price">$4.50</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🧁</div>
                    <h3 class="product-title">French Macarons</h3>
                    <p class="product-description">Delicate French macarons in 6 different flavors, perfect for special occasions and elegant gatherings.</p>
                    <div class="product-price">$18.99</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
            </div>
        </div>
    </section>

    <section class="section features">
        <div class="container">
            <h2 class="section-title">Why Choose Honoré Bakery?</h2>
            <div class="feature-grid">
                <div class="feature-card">
                    <div class="feature-icon">🌿</div>
                    <h4>Fresh Ingredients</h4>
                    <p>We use only the finest, locally-sourced organic ingredients in all our products.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">⏰</div>
                    <h4>Baked Daily</h4>
                    <p>Everything is baked fresh every morning, ensuring the highest quality and taste.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">❤️</div>
                    <h4>Made with Love</h4>
                    <p>Our family recipes have been passed down for generations, made with passion and care.</p>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div>
                    <h5>Honoré Bakery</h5>
                    <p>Fresh artisan breads and pastries made daily with love and tradition.</p>
                </div>
                <div>
                    <h5>Quick Links</h5>
                    <ul style="list-style: none;">
                        <li><a href="bakery_homepage.php">Home</a></li>
                        <li><a href="bakery_about.php">About</a></li>
                        <li><a href="bakery_contact.php">Contact</a></li>
                        <li><a href="bakery_products.php">Products</a></li>
                    </ul>
                </div>
                <div>
                    <h5>Contact Info</h5>
                    <p>📍 123 Baker Street, Downtown</p>
                    <p>📞 (555) 123-BAKE</p>
                    <p>✉️ hello@honorebakery.com</p>
                </div>
                <div>
                    <h5>Store Hours</h5>
                    <p><strong>Mon-Fri:</strong> 6AM-8PM</p>
                    <p><strong>Saturday:</strong> 6AM-8PM</p>
                    <p><strong>Sunday:</strong> 7AM-6PM</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>