<?php
// Quick test to check database connection parameters
require_once 'application/config/database.php';

echo "<h2>Database Configuration Test</h2>";

echo "<p><strong>Host:</strong> " . $db['default']['hostname'] . "</p>";
echo "<p><strong>Database:</strong> " . $db['default']['database'] . "</p>";
echo "<p><strong>Username:</strong> " . $db['default']['username'] . "</p>";
echo "<p><strong>Password:</strong> " . (empty($db['default']['password']) ? '[EMPTY]' : '[SET]') . "</p>";

try {
    $pdo = new PDO(
        "mysql:host=" . $db['default']['hostname'] . ";dbname=" . $db['default']['database'], 
        $db['default']['username'], 
        $db['default']['password']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p style='color: green;'><strong>✓ Database connection: SUCCESS</strong></p>";
    
    // Test query to check if tblitems exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'tblitems'");
    $table_exists = $stmt->fetch();
    
    if ($table_exists) {
        echo "<p style='color: green;'><strong>✓ tblitems table exists</strong></p>";
        
        // Check products count
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM tblitems WHERE rate > 0");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>Products with price > 0:</strong> " . $result['count'] . "</p>";
        
        // Show sample product
        $stmt = $pdo->query("SELECT id, description, rate FROM tblitems WHERE rate > 0 LIMIT 1");
        $sample = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($sample) {
            echo "<p><strong>Sample product:</strong></p>";
            echo "<ul>";
            echo "<li>ID: " . $sample['id'] . "</li>";
            echo "<li>Name: " . $sample['description'] . "</li>";
            echo "<li>Price: " . $sample['rate'] . "</li>";
            echo "</ul>";
        }
    } else {
        echo "<p style='color: red;'><strong>✗ tblitems table NOT found</strong></p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'><strong>✗ Database connection failed:</strong> " . $e->getMessage() . "</p>";
}
?>