<?php
// Debug script to check products in database
require_once 'application/config/database.php';

$host = $db['default']['hostname'];
$username = $db['default']['username'];
$password = $db['default']['password'];
$database = $db['default']['database'];

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Database Connection: SUCCESS</h2>";
    
    // Check items table
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM tblitems");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>Total items in tblitems: " . $result['count'] . "</p>";
    
    // Get first 5 items
    $stmt = $pdo->query("SELECT id, description, rate, group_id FROM tblitems LIMIT 5");
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>First 5 items:</h3>";
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Description</th><th>Rate</th><th>Group ID</th></tr>";
    foreach ($items as $item) {
        echo "<tr>";
        echo "<td>" . $item['id'] . "</td>";
        echo "<td>" . $item['description'] . "</td>";
        echo "<td>" . $item['rate'] . "</td>";
        echo "<td>" . $item['group_id'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Check groups table
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM tblitems_groups");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>Total groups in tblitems_groups: " . $result['count'] . "</p>";
    
    // Get all groups
    $stmt = $pdo->query("SELECT id, name FROM tblitems_groups");
    $groups = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>All groups:</h3>";
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Name</th></tr>";
    foreach ($groups as $group) {
        echo "<tr>";
        echo "<td>" . $group['id'] . "</td>";
        echo "<td>" . $group['name'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (PDOException $e) {
    echo "<h2>Database Connection: FAILED</h2>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
?>
