<?php
// Simple debug script to find the exact error
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Debug Products Error</h1>";

echo "<h2>Step 1: Basic PHP Test</h2>";
echo "✓ PHP is working<br>";

echo "<h2>Step 2: File Existence Check</h2>";
$files_to_check = [
    'index.php',
    'application/controllers/Website_frontend.php',
    'application/views/frontend/products.php'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✓ $file exists<br>";
    } else {
        echo "✗ $file missing<br>";
    }
}

echo "<h2>Step 3: Database Connection Test</h2>";
try {
    $pdo = new PDO("mysql:host=localhost;dbname=erp_ecom", 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✓ Database connection successful<br>";
    
    // Test query
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM tblitems WHERE rate > 0 AND id > 10");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "✓ Found " . $result['count'] . " products in database<br>";
    
} catch (Exception $e) {
    echo "✗ Database error: " . $e->getMessage() . "<br>";
}

echo "<h2>Step 4: CodeIgniter Bootstrap Test</h2>";
try {
    // Set up minimal environment
    $_SERVER['REQUEST_METHOD'] = 'GET';
    $_SERVER['REQUEST_URI'] = '/erp-ecom/products';
    $_SERVER['HTTP_HOST'] = 'localhost';
    $_SERVER['SCRIPT_NAME'] = '/erp-ecom/index.php';
    $_SERVER['QUERY_STRING'] = '';
    
    // Try to include CodeIgniter
    ob_start();
    include 'index.php';
    $output = ob_get_clean();
    
    echo "✓ CodeIgniter loaded successfully<br>";
    echo "Output length: " . strlen($output) . " characters<br>";
    
} catch (Exception $e) {
    echo "✗ CodeIgniter error: " . $e->getMessage() . "<br>";
    echo "Stack trace: " . $e->getTraceAsString() . "<br>";
} catch (Error $e) {
    echo "✗ Fatal error: " . $e->getMessage() . "<br>";
    echo "Stack trace: " . $e->getTraceAsString() . "<br>";
}

echo "<h2>Step 5: Direct URL Test</h2>";
echo "<p>Try accessing: <a href='http://localhost/erp-ecom/products' target='_blank'>http://localhost/erp-ecom/products</a></p>";
?>

