<?php
// Simple URL routing for clean URLs
// This file handles clean URLs like /about, /contact, /products

// Get the requested path
$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);

// Remove the base path if running in a subdirectory
$base_path = '/erp-ecom';
if (strpos($path, $base_path) === 0) {
    $path = substr($path, strlen($base_path));
}

// Remove leading slash
$path = ltrim($path, '/');

// Route to appropriate page
switch ($path) {
    case '':
    case 'home':
    case 'homepage':
        include 'modern_bakery_homepage.php';
        break;
        
    case 'about':
        include 'modern_bakery_about.php';
        break;
        
    case 'contact':
        include 'modern_bakery_contact.php';
        break;
        
    case 'products':
        include 'modern_products_catalog.php';
        break;
        
    case (preg_match('/^product\/(\d+)$/', $path, $matches) ? true : false):
        $_GET['id'] = $matches[1];
        include 'product_detail.php';
        break;
        
    case 'cart':
        include 'shopping_cart.php';
        break;
        
    case 'checkout':
        include 'checkout.php';
        break;
        
    case 'faq':
        include 'modern_bakery_faq.php';
        break;
        
    case 'privacy-policy':
    case 'privacy':
        include 'modern_bakery_privacy.php';
        break;
        
    case 'terms':
    case 'terms-of-service':
        include 'modern_bakery_terms.php';
        break;
        
    case 'refund-policy':
    case 'refund':
        include 'modern_bakery_refund.php';
        break;
        
    case 'shipping-policy':
    case 'shipping':
        include 'modern_bakery_shipping.php';
        break;
        
    case 'test-header':
        include 'test_header.php';
        break;
        
    case 'test-cart':
        include 'test_cart.php';
        break;
        
    case 'client/login':
        // Client login (singular) - redirect to login page
        header('Location: /erp-ecom/login');
        exit;
        break;
        
    case 'client/register':
        // Client register (singular) - redirect to register page
        header('Location: /erp-ecom/register');
        exit;
        break;
        
    case 'client/logout':
        // Client logout (singular) - redirect to homepage
        header('Location: /erp-ecom/');
        exit;
        break;
        
    case 'client/forgot_password':
        // Client forgot password (singular) - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'clients/login':
        // Clients login - redirect to login page
        header('Location: /erp-ecom/login');
        exit;
        break;
        
    case 'clients/register':
        // Clients register - redirect to register page
        header('Location: /erp-ecom/register');
        exit;
        break;
        
    case 'clients/logout':
        // Clients logout - redirect to homepage
        header('Location: /erp-ecom/');
        exit;
        break;
        
    case 'clients/forgot_password':
        // Clients forgot password - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'authentication/login':
        // Authentication login - redirect to login page
        header('Location: /erp-ecom/login');
        exit;
        break;
        
    case 'authentication/register':
        // Authentication register - redirect to register page
        header('Location: /erp-ecom/register');
        exit;
        break;
        
    case 'authentication/logout':
        // Authentication logout - redirect to homepage
        header('Location: /erp-ecom/');
        exit;
        break;
        
    case 'authentication/forgot_password':
        // Authentication forgot password - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'authentication/reset_password':
        // Authentication reset password - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'login':
        include 'modern_bakery_login.php';
        break;
        
    case 'register':
        include 'modern_bakery_register.php';
        break;
        
    case 'events':
        // Events page - redirect to contact for now
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'stores':
        // Store locator - redirect to contact for now
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'account':
        // Account page - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    case 'orders':
        // Orders page - redirect to contact page
        header('Location: /erp-ecom/contact');
        exit;
        break;
        
    // Website API routes
    case 'api/website/products':
    case 'api/website/categories': 
    case 'api/website/search':
    case 'api/website/test':
    case 'api/website/db-test':
        // Handle API requests by including the API handler
        include 'website_api.php';
        break;
        
    // Handle API routes with parameters (like /api/website/product/123)
    case (preg_match('/^api\/website\/product\/(\d+)$/', $path, $matches) ? true : false):
        $_GET['product_id'] = $matches[1];
        include 'website_api.php';
        break;
        
    // Cart API routes
    case 'api/website/cart':
    case 'api/website/cart/add':
    case 'api/website/cart/update':
    case 'api/website/cart/clear':
        include 'website_api.php';
        break;
        
    // Handle cart remove with ID (like /api/website/cart/remove/123)
    case (preg_match('/^api\/website\/cart\/remove\/(\d+)$/', $path, $matches) ? true : false):
        $_GET['cart_item_id'] = $matches[1];
        include 'website_api.php';
        break;
        
    default:
        // If no specific route matches, try to include the file directly
        if (file_exists($path . '.php')) {
            include $path . '.php';
        } else {
            // 404 - Page not found
            http_response_code(404);
            echo '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page Not Found - Honoré Bakery</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            text-align: center; 
            padding: 50px; 
            background: #FFF8DC; 
            color: #8B4513; 
        }
        .error-container {
            max-width: 600px;
            margin: 0 auto;
            padding: 40px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        h1 { font-size: 4rem; margin-bottom: 20px; }
        p { font-size: 1.2rem; margin-bottom: 30px; }
        .btn {
            background: #8B4513;
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            display: inline-block;
        }
        .btn:hover { background: #D2691E; }
    </style>
</head>
<body>
    <div class="error-container">
        <h1>404</h1>
        <h2>Page Not Found</h2>
        <p>The page you are looking for does not exist.</p>
        <a href="/erp-ecom/" class="btn">Go Home</a>
    </div>
</body>
</html>';
        }
        break;
}
?>
