<?php
// Simple URL routing for clean URLs - PRODUCTION VERSION
// This file handles clean URLs like /about, /contact, /products

// Get the requested path
$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);

// Remove the base path if running in a subdirectory
$base_path = '/releasepymnstpro/erp-ecom';
if (strpos($path, $base_path) === 0) {
    $path = substr($path, strlen($base_path));
}

// Remove leading slash
$path = ltrim($path, '/');

// Route to appropriate page
switch ($path) {
    case '':
    case 'home':
    case 'homepage':
        include 'modern_bakery_homepage.php';
        break;
        
    case 'about':
        include 'modern_bakery_about.php';
        break;
        
    case 'contact':
        include 'modern_bakery_contact.php';
        break;
        
    case 'products':
        include 'modern_bakery_products.php';
        break;
        
    case 'faq':
        include 'modern_bakery_faq.php';
        break;
        
    case 'privacy-policy':
    case 'privacy':
        include 'modern_bakery_privacy.php';
        break;
        
    case 'terms':
    case 'terms-of-service':
        include 'modern_bakery_terms.php';
        break;
        
    case 'refund-policy':
    case 'refund':
        include 'modern_bakery_refund.php';
        break;
        
    case 'shipping-policy':
    case 'shipping':
        include 'modern_bakery_shipping.php';
        break;
        
    case 'test-header':
        include 'test_header.php';
        break;
        
    case 'test-cart':
        include 'test_cart.php';
        break;
        
    // Redirect old routes to contact page
    case 'login':
    case 'register':
    case 'account':
    case 'orders':
        header('Location: /releasepymnstpro/erp-ecom/contact');
        exit;
        break;
        
    default:
        // 404 - Page not found
        http_response_code(404);
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>404 - Page Not Found | Honoré Bakery</title>
            <script src="https://cdn.tailwindcss.com"></script>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
            <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
            <style>
                .font-playfair { font-family: 'Playfair Display', serif; }
                .font-inter { font-family: 'Inter', sans-serif; }
                .gradient-text {
                    background: linear-gradient(135deg, #f59e0b, #d97706);
                    -webkit-background-clip: text;
                    -webkit-text-fill-color: transparent;
                    background-clip: text;
                }
            </style>
        </head>
        <body class="font-inter bg-gray-50">
            <div class="min-h-screen flex items-center justify-center px-4">
                <div class="max-w-md w-full bg-white rounded-2xl shadow-xl p-8 text-center">
                    <div class="mb-6">
                        <div class="w-16 h-16 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-bread-slice text-white text-2xl"></i>
                        </div>
                        <h1 class="text-6xl font-bold text-amber-600 mb-2">404</h1>
                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-2">Page Not Found</h2>
                        <p class="text-gray-600">The page you are looking for does not exist.</p>
                    </div>
                    
                    <div class="space-y-3">
                        <a href="/releasepymnstpro/erp-ecom/" 
                           class="block w-full bg-gradient-to-r from-amber-500 to-amber-600 text-white font-semibold py-3 px-6 rounded-xl hover:from-amber-600 hover:to-amber-700 transition-all duration-300 transform hover:scale-105">
                            <i class="fas fa-home mr-2"></i>
                            Go Home
                        </a>
                        
                        <div class="flex space-x-3">
                            <a href="/releasepymnstpro/erp-ecom/products" 
                               class="flex-1 bg-gray-100 text-gray-700 font-medium py-2 px-4 rounded-lg hover:bg-gray-200 transition-colors">
                                Products
                            </a>
                            <a href="/releasepymnstpro/erp-ecom/contact" 
                               class="flex-1 bg-gray-100 text-gray-700 font-medium py-2 px-4 rounded-lg hover:bg-gray-200 transition-colors">
                                Contact
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </body>
        </html>
        <?php
        break;
}
?>
