<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - Honoré Bakery</title>
    <meta name="description" content="Privacy Policy for Honoré Bakery. Learn how we collect, use, and protect your personal information.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="font-inter bg-gray-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <main>
        <!-- Page Header -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-4xl md:text-5xl font-playfair font-bold text-white mb-4">
                    Privacy <span class="text-amber-200">Policy</span>
                </h1>
                <p class="text-xl text-amber-100">
                    Your privacy is important to us. Learn how we collect, use, and protect your information.
                </p>
            </div>
        </section>

        <!-- Privacy Policy Content -->
        <section class="py-16">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white rounded-lg shadow-lg p-8 md:p-12">
                    <div class="prose prose-lg max-w-none">
                        <p class="text-gray-600 mb-8">
                            <strong>Last updated:</strong> December 2024
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">1. Information We Collect</h2>
                        <p class="text-gray-700 mb-6">
                            We collect information you provide directly to us, such as when you create an account, 
                            make a purchase, or contact us for support. This may include:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Name and contact information (email address, phone number)</li>
                            <li>Billing and shipping addresses</li>
                            <li>Payment information (processed securely through our payment partners)</li>
                            <li>Order history and preferences</li>
                            <li>Communication preferences</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">2. How We Use Your Information</h2>
                        <p class="text-gray-700 mb-6">
                            We use the information we collect to:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Process and fulfill your orders</li>
                            <li>Provide customer support and respond to inquiries</li>
                            <li>Send order confirmations and shipping updates</li>
                            <li>Improve our products and services</li>
                            <li>Send marketing communications (with your consent)</li>
                            <li>Comply with legal obligations</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">3. Information Sharing</h2>
                        <p class="text-gray-700 mb-6">
                            We do not sell, trade, or otherwise transfer your personal information to third parties, 
                            except in the following circumstances:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>With service providers who assist us in operating our business</li>
                            <li>With payment processors to complete transactions</li>
                            <li>With shipping companies to deliver your orders</li>
                            <li>When required by law or to protect our rights</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">4. Data Security</h2>
                        <p class="text-gray-700 mb-6">
                            We implement appropriate security measures to protect your personal information against 
                            unauthorized access, alteration, disclosure, or destruction. This includes:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>SSL encryption for data transmission</li>
                            <li>Secure servers and databases</li>
                            <li>Regular security audits and updates</li>
                            <li>Limited access to personal information</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">5. Your Rights</h2>
                        <p class="text-gray-700 mb-6">
                            You have the right to:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Access and update your personal information</li>
                            <li>Request deletion of your account and data</li>
                            <li>Opt-out of marketing communications</li>
                            <li>Request a copy of your data</li>
                            <li>Withdraw consent for data processing</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">6. Cookies and Tracking</h2>
                        <p class="text-gray-700 mb-6">
                            We use cookies and similar technologies to enhance your browsing experience, 
                            analyze site traffic, and personalize content. You can control cookie settings 
                            through your browser preferences.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">7. Contact Us</h2>
                        <p class="text-gray-700 mb-6">
                            If you have any questions about this Privacy Policy or our data practices, 
                            please contact us:
                        </p>
                        <div class="bg-amber-50 p-6 rounded-lg">
                            <p class="text-gray-700 mb-2">
                                <strong>Email:</strong> privacy@honorebakery.com
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>Phone:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700">
                                <strong>Address:</strong> 123 Baker Street, Downtown District
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>
    <?php include 'cart_component.php'; ?>
</body>
</html>
