<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Refund Policy - Honoré Bakery</title>
    <meta name="description" content="Refund Policy for Honoré Bakery. Learn about our return and refund procedures.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="font-inter bg-gray-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <main>
        <!-- Page Header -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-4xl md:text-5xl font-playfair font-bold text-white mb-4">
                    Refund <span class="text-amber-200">Policy</span>
                </h1>
                <p class="text-xl text-amber-100">
                    Our commitment to your satisfaction with our products and services.
                </p>
            </div>
        </section>

        <!-- Refund Policy Content -->
        <section class="py-16">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white rounded-lg shadow-lg p-8 md:p-12">
                    <div class="prose prose-lg max-w-none">
                        <p class="text-gray-600 mb-8">
                            <strong>Last updated:</strong> December 2024
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">1. Our Refund Commitment</h2>
                        <p class="text-gray-700 mb-6">
                            At Honoré Bakery, we are committed to providing you with the highest quality products. 
                            If you are not completely satisfied with your purchase, we offer a comprehensive refund 
                            policy to ensure your peace of mind.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">2. Eligibility for Refunds</h2>
                        <p class="text-gray-700 mb-6">
                            You may be eligible for a refund if:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Your order was damaged during delivery</li>
                            <li>You received the wrong product</li>
                            <li>The product quality does not meet our standards</li>
                            <li>You are not satisfied with your purchase (within 7 days)</li>
                            <li>Your order was cancelled before processing</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">3. Refund Timeframes</h2>
                        <div class="bg-amber-50 p-6 rounded-lg mb-8">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Processing Times:</h3>
                            <ul class="space-y-2 text-gray-700">
                                <li><strong>Fresh Products (Bread, Pastries):</strong> 24 hours from delivery</li>
                                <li><strong>Cakes & Custom Orders:</strong> 48 hours from delivery</li>
                                <li><strong>Flowers:</strong> 12 hours from delivery</li>
                                <li><strong>General Products:</strong> 7 days from delivery</li>
                            </ul>
                        </div>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">4. How to Request a Refund</h2>
                        <p class="text-gray-700 mb-6">
                            To request a refund, please follow these steps:
                        </p>
                        <ol class="list-decimal list-inside text-gray-700 mb-8 space-y-2">
                            <li>Contact us within the specified timeframe</li>
                            <li>Provide your order number and reason for refund</li>
                            <li>Take photos of the product (if applicable)</li>
                            <li>Return the product in its original packaging (if required)</li>
                            <li>Wait for our team to review your request</li>
                        </ol>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">5. Refund Methods</h2>
                        <p class="text-gray-700 mb-6">
                            Refunds will be processed using the same payment method used for the original purchase:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li><strong>Credit/Debit Cards:</strong> 3-5 business days</li>
                            <li><strong>UPI Payments:</strong> 1-2 business days</li>
                            <li><strong>Net Banking:</strong> 3-7 business days</li>
                            <li><strong>Cash on Delivery:</strong> Bank transfer or store credit</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">6. Non-Refundable Items</h2>
                        <p class="text-gray-700 mb-6">
                            The following items are not eligible for refunds:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Custom-made cakes (unless quality issue)</li>
                            <li>Perishable items consumed after delivery</li>
                            <li>Items damaged by customer negligence</li>
                            <li>Products returned after the specified timeframe</li>
                            <li>Items without original packaging</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">7. Partial Refunds</h2>
                        <p class="text-gray-700 mb-6">
                            In some cases, we may offer partial refunds for:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Minor quality issues that don't affect the entire product</li>
                            <li>Late delivery (refund of delivery charges)</li>
                            <li>Missing items from a larger order</li>
                            <li>Products that are partially consumed</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">8. Store Credit Option</h2>
                        <p class="text-gray-700 mb-6">
                            Instead of a monetary refund, you may choose to receive store credit that can be used 
                            for future purchases. Store credit:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Is valid for 6 months from issue date</li>
                            <li>Can be used for any product on our website</li>
                            <li>Cannot be transferred to another person</li>
                            <li>Cannot be exchanged for cash</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">9. Quality Assurance</h2>
                        <p class="text-gray-700 mb-6">
                            We maintain strict quality standards and conduct regular quality checks. If you receive 
                            a product that doesn't meet our standards, we will:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Provide immediate replacement</li>
                            <li>Offer full refund</li>
                            <li>Investigate the issue to prevent recurrence</li>
                            <li>Provide compensation for inconvenience</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">10. Contact Us</h2>
                        <p class="text-gray-700 mb-6">
                            For refund requests or questions about our refund policy, please contact us:
                        </p>
                        <div class="bg-amber-50 p-6 rounded-lg">
                            <p class="text-gray-700 mb-2">
                                <strong>Email:</strong> refunds@honorebakery.com
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>Phone:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>WhatsApp:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700">
                                <strong>Address:</strong> 123 Baker Street, Downtown District
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>
    <?php include 'cart_component.php'; ?>
</body>
</html>
