<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Honoré Bakery</title>
    <meta name="description" content="Create your Honoré Bakery account to enjoy exclusive offers, track orders, and manage your preferences.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .font-playfair { font-family: 'Playfair Display', 'serif'; }
        .font-inter { font-family: 'Inter', 'sans-serif'; }
        
        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }
        
        /* Custom animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.6s ease-out;
        }
    </style>
</head>
<body class="font-inter bg-amber-50 text-gray-900">
    <?php include 'header_component.php'; ?>
    
    <!-- Main Content -->
    <main class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8">
            <!-- Header -->
            <div class="text-center animate-fadeInUp">
                <div class="mx-auto h-16 w-16 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-bread-slice text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-playfair font-bold gradient-text mb-2">Join Honoré Bakery</h2>
                <p class="text-gray-600">Create your account and start your delicious journey</p>
            </div>
            
            <!-- Register Form -->
            <div class="bg-white rounded-2xl shadow-xl p-8 animate-fadeInUp" style="animation-delay: 0.2s;">
                <form class="space-y-6" id="registerForm">
                    <!-- Full Name -->
                    <div>
                        <label for="fullName" class="block text-sm font-medium text-gray-700 mb-2">
                            Full Name
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-user text-gray-400"></i>
                            </div>
                            <input id="fullName" name="fullName" type="text" autocomplete="name" required
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                   placeholder="Enter your full name">
                        </div>
                    </div>
                    
                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                            Email Address
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-envelope text-gray-400"></i>
                            </div>
                            <input id="email" name="email" type="email" autocomplete="email" required
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                   placeholder="Enter your email address">
                        </div>
                    </div>
                    
                    <!-- Phone Number -->
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                            Phone Number
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-phone text-gray-400"></i>
                            </div>
                            <input id="phone" name="phone" type="tel" autocomplete="tel" required
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                   placeholder="Enter your phone number">
                        </div>
                    </div>
                    
                    <!-- Password -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                            Password
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-400"></i>
                            </div>
                            <input id="password" name="password" type="password" autocomplete="new-password" required
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                   placeholder="Create a password">
                        </div>
                    </div>
                    
                    <!-- Confirm Password -->
                    <div>
                        <label for="confirmPassword" class="block text-sm font-medium text-gray-700 mb-2">
                            Confirm Password
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-400"></i>
                            </div>
                            <input id="confirmPassword" name="confirmPassword" type="password" autocomplete="new-password" required
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                   placeholder="Confirm your password">
                        </div>
                    </div>
                    
                    <!-- Terms and Conditions -->
                    <div class="flex items-start">
                        <div class="flex items-center h-5">
                            <input id="terms" name="terms" type="checkbox" required
                                   class="h-4 w-4 text-amber-600 focus:ring-amber-500 border-gray-300 rounded">
                        </div>
                        <div class="ml-3 text-sm">
                            <label for="terms" class="text-gray-700">
                                I agree to the 
                                <a href="/erp-ecom/terms" class="font-medium text-amber-600 hover:text-amber-500 transition-colors">
                                    Terms of Service
                                </a> 
                                and 
                                <a href="/erp-ecom/privacy-policy" class="font-medium text-amber-600 hover:text-amber-500 transition-colors">
                                    Privacy Policy
                                </a>
                            </label>
                        </div>
                    </div>
                    
                    <!-- Newsletter Subscription -->
                    <div class="flex items-center">
                        <div class="flex items-center h-5">
                            <input id="newsletter" name="newsletter" type="checkbox"
                                   class="h-4 w-4 text-amber-600 focus:ring-amber-500 border-gray-300 rounded">
                        </div>
                        <div class="ml-3 text-sm">
                            <label for="newsletter" class="text-gray-700">
                                Subscribe to our newsletter for exclusive offers and updates
                            </label>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div>
                        <button type="submit"
                                class="group relative w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-lg text-white bg-amber-600 hover:bg-amber-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500 transition-all duration-300 transform hover:scale-105">
                            <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                                <i class="fas fa-user-plus text-amber-500 group-hover:text-amber-400"></i>
                            </span>
                            Create Account
                        </button>
                    </div>
                </form>
                
                <!-- Divider -->
                <div class="mt-6">
                    <div class="relative">
                        <div class="absolute inset-0 flex items-center">
                            <div class="w-full border-t border-gray-300"></div>
                        </div>
                        <div class="relative flex justify-center text-sm">
                            <span class="px-2 bg-white text-gray-500">Or continue with</span>
                        </div>
                    </div>
                </div>
                
                <!-- Social Register -->
                <div class="mt-6 grid grid-cols-2 gap-3">
                    <button type="button"
                            class="w-full inline-flex justify-center py-2 px-4 border border-gray-300 rounded-lg shadow-sm bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 transition-colors">
                        <i class="fab fa-google text-red-500"></i>
                        <span class="ml-2">Google</span>
                    </button>
                    <button type="button"
                            class="w-full inline-flex justify-center py-2 px-4 border border-gray-300 rounded-lg shadow-sm bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 transition-colors">
                        <i class="fab fa-facebook text-blue-600"></i>
                        <span class="ml-2">Facebook</span>
                    </button>
                </div>
            </div>
            
            <!-- Login Link -->
            <div class="text-center animate-fadeInUp" style="animation-delay: 0.4s;">
                <p class="text-gray-600">
                    Already have an account?
                    <a href="/erp-ecom/login" class="font-medium text-amber-600 hover:text-amber-500 transition-colors">
                        Sign in here
                    </a>
                </p>
            </div>
            
            <!-- Back to Home -->
            <div class="text-center animate-fadeInUp" style="animation-delay: 0.6s;">
                <a href="/erp-ecom/" class="inline-flex items-center text-gray-600 hover:text-amber-600 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Back to Home
                </a>
            </div>
        </div>
    </main>

    <!-- Modern Footer Component -->
    <?php include 'modern_footer_component.php'; ?>

    <?php include 'cart_component.php'; ?>

    <!-- JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const registerForm = document.getElementById('registerForm');
            
            registerForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Get form data
                const fullName = document.getElementById('fullName').value;
                const email = document.getElementById('email').value;
                const phone = document.getElementById('phone').value;
                const password = document.getElementById('password').value;
                const confirmPassword = document.getElementById('confirmPassword').value;
                const terms = document.getElementById('terms').checked;
                const newsletter = document.getElementById('newsletter').checked;
                
                // Basic validation
                if (!fullName || !email || !phone || !password || !confirmPassword) {
                    alert('Please fill in all required fields.');
                    return;
                }
                
                if (!terms) {
                    alert('Please accept the Terms of Service and Privacy Policy.');
                    return;
                }
                
                // Email validation
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(email)) {
                    alert('Please enter a valid email address.');
                    return;
                }
                
                // Phone validation (basic)
                const phoneRegex = /^[\+]?[1-9][\d]{0,15}$/;
                if (!phoneRegex.test(phone.replace(/\s/g, ''))) {
                    alert('Please enter a valid phone number.');
                    return;
                }
                
                // Password validation
                if (password.length < 6) {
                    alert('Password must be at least 6 characters long.');
                    return;
                }
                
                if (password !== confirmPassword) {
                    alert('Passwords do not match.');
                    return;
                }
                
                // Simulate registration process
                const submitButton = registerForm.querySelector('button[type="submit"]');
                const originalText = submitButton.innerHTML;
                
                submitButton.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Creating Account...';
                submitButton.disabled = true;
                
                // Simulate API call
                setTimeout(() => {
                    // For demo purposes, show success message
                    alert('Account created successfully! (This is a demo - no actual registration is implemented)');
                    
                    // Reset button
                    submitButton.innerHTML = originalText;
                    submitButton.disabled = false;
                    
                    // Redirect to login page
                    window.location.href = '/erp-ecom/login';
                }, 2000);
            });
            
            // Social register handlers
            document.querySelectorAll('button[type="button"]').forEach(button => {
                button.addEventListener('click', function() {
                    const provider = this.textContent.trim();
                    alert(`${provider} registration clicked! (This is a demo - no actual social registration is implemented)`);
                });
            });
            
            // Password confirmation validation
            document.getElementById('confirmPassword').addEventListener('input', function() {
                const password = document.getElementById('password').value;
                const confirmPassword = this.value;
                
                if (confirmPassword && password !== confirmPassword) {
                    this.setCustomValidity('Passwords do not match');
                } else {
                    this.setCustomValidity('');
                }
            });
        });
    </script>
</body>
</html>
