<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Service - Honoré Bakery</title>
    <meta name="description" content="Terms of Service for Honoré Bakery. Read our terms and conditions for using our services.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="font-inter bg-gray-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <main>
        <!-- Page Header -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-4xl md:text-5xl font-playfair font-bold text-white mb-4">
                    Terms of <span class="text-amber-200">Service</span>
                </h1>
                <p class="text-xl text-amber-100">
                    Please read these terms carefully before using our services.
                </p>
            </div>
        </section>

        <!-- Terms Content -->
        <section class="py-16">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white rounded-lg shadow-lg p-8 md:p-12">
                    <div class="prose prose-lg max-w-none">
                        <p class="text-gray-600 mb-8">
                            <strong>Last updated:</strong> December 2024
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">1. Acceptance of Terms</h2>
                        <p class="text-gray-700 mb-6">
                            By accessing and using Honoré Bakery's website and services, you accept and agree to be bound 
                            by the terms and provision of this agreement. If you do not agree to abide by the above, 
                            please do not use this service.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">2. Use License</h2>
                        <p class="text-gray-700 mb-6">
                            Permission is granted to temporarily download one copy of the materials on Honoré Bakery's 
                            website for personal, non-commercial transitory viewing only. This is the grant of a license, 
                            not a transfer of title, and under this license you may not:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Modify or copy the materials</li>
                            <li>Use the materials for any commercial purpose or for any public display</li>
                            <li>Attempt to reverse engineer any software contained on the website</li>
                            <li>Remove any copyright or other proprietary notations from the materials</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">3. Orders and Payment</h2>
                        <p class="text-gray-700 mb-6">
                            When you place an order with us, you agree to:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Provide accurate and complete information</li>
                            <li>Pay all charges incurred by your account</li>
                            <li>Comply with all applicable laws and regulations</li>
                            <li>Be responsible for all activities under your account</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">4. Product Information</h2>
                        <p class="text-gray-700 mb-6">
                            We strive to provide accurate product descriptions and images. However, we do not warrant 
                            that product descriptions or other content is accurate, complete, reliable, current, or 
                            error-free. If a product offered by us is not as described, your sole remedy is to return 
                            it in unused condition.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">5. Pricing and Availability</h2>
                        <p class="text-gray-700 mb-6">
                            All prices are subject to change without notice. We reserve the right to limit quantities 
                            and to discontinue any product at any time. We are not responsible for typographical errors 
                            regarding price or any other matter.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">6. User Accounts</h2>
                        <p class="text-gray-700 mb-6">
                            You are responsible for maintaining the confidentiality of your account and password. 
                            You agree to accept responsibility for all activities that occur under your account or password.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">7. Prohibited Uses</h2>
                        <p class="text-gray-700 mb-6">
                            You may not use our service:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>For any unlawful purpose or to solicit others to perform unlawful acts</li>
                            <li>To violate any international, federal, provincial, or state regulations, rules, laws, or local ordinances</li>
                            <li>To infringe upon or violate our intellectual property rights or the intellectual property rights of others</li>
                            <li>To harass, abuse, insult, harm, defame, slander, disparage, intimidate, or discriminate</li>
                            <li>To submit false or misleading information</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">8. Limitation of Liability</h2>
                        <p class="text-gray-700 mb-6">
                            In no event shall Honoré Bakery, nor its directors, employees, partners, agents, suppliers, 
                            or affiliates, be liable for any indirect, incidental, special, consequential, or punitive 
                            damages, including without limitation, loss of profits, data, use, goodwill, or other 
                            intangible losses, resulting from your use of the service.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">9. Governing Law</h2>
                        <p class="text-gray-700 mb-6">
                            These terms shall be interpreted and governed by the laws of India, without regard to 
                            its conflict of law provisions. Our failure to enforce any right or provision of these 
                            terms will not be considered a waiver of those rights.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">10. Changes to Terms</h2>
                        <p class="text-gray-700 mb-6">
                            We reserve the right, at our sole discretion, to modify or replace these terms at any time. 
                            If a revision is material, we will try to provide at least 30 days notice prior to any 
                            new terms taking effect.
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">11. Contact Information</h2>
                        <p class="text-gray-700 mb-6">
                            If you have any questions about these Terms of Service, please contact us:
                        </p>
                        <div class="bg-amber-50 p-6 rounded-lg">
                            <p class="text-gray-700 mb-2">
                                <strong>Email:</strong> legal@honorebakery.com
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>Phone:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700">
                                <strong>Address:</strong> 123 Baker Street, Downtown District
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>
    <?php include 'cart_component.php'; ?>
</body>
</html>
