<?php 
	  $currency_name = '';
	  if(isset($base_currency)){
	    $currency_name = $base_currency->name;
	  }
	  $array_list_id = [];
	  if(isset($_COOKIE['cart_id_list'])){
	    $list_id = $_COOKIE['cart_id_list'];
	    if($list_id){
	        $array_list_id = explode(',',$list_id);
	    }
	  }

	  // Bakery shop time logic
	  $now = date('H:i');
	  $today = strtolower(date('l')); // e.g. 'monday'
	  $current_date = date('Y-m-d');
	  $order_open = false;
	  $show_end_msg = false;
	  $show_start_msg = false;

	  // Helper to get time minus minutes
	function time_minus_minutes($time, $minutes) {
	    $dt = DateTime::createFromFormat('H:i', $time);
	    if ($dt) {
	        $dt->modify("-{$minutes} minutes");
	        return $dt->format('H:i');
	    }
	    return $time;
	}

	  // Check special dates first
	  $special_open = false;
	  $special_date_found = false;
	  if (!empty($special_dates)) {
	      foreach ($special_dates as $row) {

	          if ($row['date'] == $current_date) {
				$special_date_found = true;
	              $start_time = $row['start_time'];
	              $end_time = $row['end_time'];
	              $half_hour_before_end = time_minus_minutes($end_time, 30);

	              // Use strtotime for accurate comparison
	              if (strtotime($now) >= strtotime($start_time) && strtotime($now) < strtotime($end_time)) {
	                  $order_open = true;
	                  $special_open = true;
	                  if (strtotime($now) >= strtotime($half_hour_before_end) && strtotime($now) < strtotime($end_time)) {
	                      $show_end_msg = true;
	                  }
	              } else {
	                  if (strtotime($now) < strtotime($start_time)) {
	                      $show_start_msg = true;
	                  } elseif (strtotime($now) >= strtotime($end_time)) {
	                      $show_end_msg = false;
	                  }
	              }
	              break;
	          }
	      }
	  }
	  

	  // If not special date, check weekday config
	  if (!$special_date_found) {
	      $start_time = isset(${$today . '_start_time'}) ? ${$today . '_start_time'} : '';
	      $end_time = isset(${$today . '_end_time'}) ? ${$today . '_end_time'} : '';
	      $half_hour_before_end = time_minus_minutes($end_time, 30);
	      if ($start_time && $end_time && strtotime($now) >= strtotime($start_time) && strtotime($now) < strtotime($end_time)) {
	          $order_open = true;
	          if (strtotime($now) >= strtotime($half_hour_before_end) && strtotime($now) < strtotime($end_time)) {
	              $show_end_msg = true;
	          }
	      } else {
	          if ($start_time && strtotime($now) < strtotime($start_time)) {
	              $show_start_msg = true;
	          }
	          if ($end_time && strtotime($now) >= strtotime($end_time)) {
	              $show_end_msg = false;
	          }
	      }
	  }

	    if (empty($start_time) && empty($end_time)) {
			$order_open = true;
			$show_end_msg = false;
			$show_start_msg = false;
		}
?>
<?php
$per_row = isset($portal_row_product_show) && $portal_row_product_show > 0 ? (int)$portal_row_product_show : 3;
$total = count($product);
?>

<div class="row">
<?php foreach ($product as $i => $item) { ?>
            <div class="col-lg-<?php echo floor(12/$per_row); ?> col-md-<?php echo floor(12/$per_row); ?> col-sm-6 col-12 grid">
        <div class="grid product-cell <?php echo !$order_open ? 'product-disabled' : ''; ?>" id="product-cell-<?php echo $item['id']; ?>">
            <div class="product-image"> 
                <a href="<?php 	echo site_url('product/'.$item['id']); ?>"> 
                <img class="pic-1" src="<?php echo $this->omni_sales_model->get_image_items($item['id']); ?>">
                </a>               					                  
            </div>
            <div class="product-content">
                <div class="title"><a href="<?php echo site_url('product/'.$item['id']); ?>"><?php echo html_entity_decode($item['name']); ?></a></div> 
                <span class="price">
                        <?php echo app_format_money($item['price'],$currency_name); ?>	
                                            
                </span>					                    
            </div>
            <div class="pb-1 add-cart">
                <?php if($item['w_quantity'] != 0){  ?>
                    
                    <?php if ($show_end_msg): ?>
                        <div class="alert alert-info text-center">
                            <?php echo _l('order_will_close_after'); ?> <span id="order-close-timer-<?php echo $item['id']; ?>"></span>
                        </div>
                    <?php endif; ?>
                <input type="number" name="qty" class="form-control qty" value="1" min="1" max="<?php echo html_entity_decode($item['w_quantity']); ?>" data-w_quantity="<?php echo html_entity_decode($item['w_quantity']); ?>" <?php echo !$order_open ? 'disabled' : ''; ?>>
                <button type="button" class="added btn btn-primary <?php if(in_array($item['id'],$array_list_id)){ echo ''; }else{ echo 'hide'; } ?>" data-id="<?php echo html_entity_decode($item['id']); ?>" <?php echo !$order_open ? 'disabled' : ''; ?>><i class="fa fa-shopping-cart"></i> <?php echo _l('added'); ?></button>	
                <button type="button" class="add_cart btn btn-success <?php if(in_array($item['id'],$array_list_id)){ echo 'hide'; }else{ echo ''; } ?>" data-id="<?php echo html_entity_decode($item['id']); ?>" <?php echo !$order_open ? 'disabled' : ''; ?>><i class="fa fa-shopping-cart"></i> <?php echo _l('add_to_cart'); ?></button>
                <?php }else{ ?>
                    <button class="btn btn-default"><?php echo _l('out_of_stock'); ?></button>
                <?php } ?>
            </div>
            <?php if(!$order_open): ?>
            <div class="product-overlay">
                <span class="overlay-text">
                    <?php echo $show_start_msg ? _l('order_will_start_from').' '.$start_time : _l('order_closed'); ?>
                </span>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php if (($i + 1) % $per_row == 0 && ($i + 1) < $total): ?>
        </div><div class="row">
    <?php endif; ?>
<?php } ?>
</div>


<style>
/* Product grid spacing */
.grid.product-cell {
    border: 1px solid #eee;
    padding: 15px;
    margin-bottom: 20px;
    text-align: center;
    position: relative;
    border-radius: 8px;
    background: #fff;
}

/* Product title */
.product-content .title {
    font-size: 16px;
    font-weight: 600;
    margin: 10px 0;
}

/* Price styling */
.product-content .price {
    display: block;
    margin: 5px 0 10px;
    font-size: 15px;
    color: #333;
}

/* Quantity input box */
.add-cart input.qty {
    width: 60px;
    display: inline-block;
    margin-right: 8px;
    text-align: center;
}

/* Cart buttons */
.add-cart button {
    min-width: 120px;
    padding: 6px 10px;
    font-size: 14px;
    border-radius: 5px;
}

/* Align Added and Add to cart buttons */
.add-cart .btn {
    display: inline-block;
    vertical-align: middle;
    margin-top: 8px;
}

/* Add spacing between buttons */
.add-cart .btn + .btn {
    margin-left: 5px;
}

/* Overlay when product disabled */
.product-overlay {
    position: absolute;
    top: 0;
    left: 0;
    background: rgba(255,255,255,0.85);
    width: 100%;
    height: 100%;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
}
.product-overlay .overlay-text {
    font-size: 14px;
    font-weight: bold;
    color: #d9534f;
}
</style>


<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get PHP time variables
    var startTime = '<?php echo $start_time; ?>';
    var endTime = '<?php echo $end_time; ?>';

    // If both times are empty, shop is always open
    if (!startTime && !endTime) {
        // Enable all cart buttons
        var cartBtns = document.querySelectorAll('a#ecom_cart');
        cartBtns.forEach(function(btn) {
            btn.classList.remove('disabled');
            btn.removeAttribute('aria-disabled');
            btn.style.pointerEvents = '';
            btn.style.opacity = '';
        });
        var viewCartBtn = document.getElementById('view_cart_and_checkout');
        if (viewCartBtn) {
            viewCartBtn.classList.remove('disabled');
            viewCartBtn.removeAttribute('aria-disabled');
            viewCartBtn.style.pointerEvents = '';
            viewCartBtn.style.opacity = '';
        }
        // Hide any timer or closed message if present
        var timerElems = document.querySelectorAll('[id^="order-close-timer"]');
        timerElems.forEach(function(timerElem) {
            if (timerElem) timerElem.style.display = 'none';
        });
        var overlays = document.querySelectorAll('.product-overlay');
        overlays.forEach(function(overlay) {
            if (overlay) overlay.style.display = 'none';
        });
        // Exit further timer logic
        return;
    }

    // Get current browser time in HH:mm format
    var now = new Date();
    var nowStr = now.getHours().toString().padStart(2, '0') + ':' + now.getMinutes().toString().padStart(2, '0');

    // Helper to compare time strings
    function timeLess(a, b) {
        return a < b;
    }
    function timeGreaterOrEqual(a, b) {
        return a >= b;
    }

    var orderOpen = true;
    if (startTime && timeLess(nowStr, startTime)) {
        orderOpen = false;
    }
    if (endTime) {
        // Calculate half an hour before end time
        var endParts = endTime.split(':');
        var endDate = new Date();
        endDate.setHours(parseInt(endParts[0]), parseInt(endParts[1]), 0, 0);
        var halfHourBefore = new Date(endDate.getTime() - 30 * 60000);
        var halfHourStr = halfHourBefore.getHours().toString().padStart(2, '0') + ':' + halfHourBefore.getMinutes().toString().padStart(2, '0');
        if (timeGreaterOrEqual(nowStr, endTime)) {
            orderOpen = false;
        }
    }

    // Disable all cart anchor buttons with id 'ecom_cart'
    var cartBtns = document.querySelectorAll('a#ecom_cart');
	var viewCartBtn = document.getElementById('view_cart_and_checkout');
    cartBtns.forEach(function(btn) {
        if (!orderOpen) {
            btn.classList.add('disabled');
            btn.setAttribute('aria-disabled', 'true');
            btn.style.pointerEvents = 'none';
            btn.style.opacity = '0.6';
        } else {
            btn.classList.remove('disabled');
            btn.removeAttribute('aria-disabled');
            btn.style.pointerEvents = '';
            btn.style.opacity = '';
        }
    });
    if (viewCartBtn && !orderOpen) {
        viewCartBtn.classList.add('disabled');
        viewCartBtn.setAttribute('aria-disabled', 'true');
        viewCartBtn.style.pointerEvents = 'none';
        viewCartBtn.style.opacity = '0.6';
        viewCartBtn.title = '<?php echo _l('order_closed'); ?>';
    }

    // Countdown timer for closing
    var endTimeStr = '<?php echo $end_time; ?>';
    var now = new Date();
    var endParts = endTimeStr.split(':');
    var endDate = new Date();
    endDate.setHours(parseInt(endParts[0]), parseInt(endParts[1]), 0, 0);

    function updateTimer() {
        var now = new Date();
        var diff = endDate - now;
        if (diff > 0) {
            var hours = Math.floor(diff / (1000 * 60 * 60));
            var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((diff % (1000 * 60)) / 1000);
            document.getElementById('order-close-timer').textContent =
                (hours > 0 ? hours + 'h ' : '') + minutes + 'm ' + seconds + 's';
        } else {
            document.getElementById('order-close-timer').textContent = '00m 00s';
        }
    }

    // Only show timer if element exists
    if (document.getElementById('order-close-timer')) {
        updateTimer();
        setInterval(updateTimer, 1000);
    }
});
<?php foreach ($product as $item) { 
        // Only show timer if $show_end_msg is true for this product
        if ($show_end_msg): 
    ?>
    (function() {
        var endTimeStr = '<?php echo $end_time; ?>';
        var timerId = 'order-close-timer-<?php echo $item['id']; ?>';
        var productCellId = 'product-cell-<?php echo $item['id']; ?>';
        var endParts = endTimeStr.split(':');
        var endDate = new Date();
        endDate.setHours(parseInt(endParts[0]), parseInt(endParts[1]), 0, 0);

        function updateTimer_<?php echo $item['id']; ?>() {
            var now = new Date();
            var diff = endDate - now;
            var timerElem = document.getElementById(timerId);
            var productCell = document.getElementById(productCellId);
            // Find the alert div
            var alertDiv = timerElem ? timerElem.closest('.alert') : null;
            if (timerElem) {
                if (diff > 0) {
                    var hours = Math.floor(diff / (1000 * 60 * 60));
                    var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((diff % (1000 * 60)) / 1000);
                    timerElem.textContent =
                        (hours > 0 ? hours + 'h ' : '') + minutes + 'm ' + seconds + 's';
                } else {
                    timerElem.textContent = '00m 00s';
                    // Hide or remove the alert div
                    if (alertDiv) {
                        alertDiv.style.display = 'none'; // or use alertDiv.remove();
                    }
                    // Disable product
                    if (productCell && !productCell.classList.contains('product-disabled')) {
                        productCell.classList.add('product-disabled');
                        // Show overlay message
                        var overlay = document.createElement('div');
                        overlay.className = 'product-overlay';
                        overlay.innerHTML = '<span class="overlay-text"><?php echo _l('order_closed'); ?></span>';
                        productCell.appendChild(overlay);
                    }
                    // Disable ecom_cart button for this product
                    // Disable all cart anchor buttons with id 'ecom_cart'
					var cartBtns = document.querySelectorAll('a#ecom_cart');
					cartBtns.forEach(function(btn) {
						if (timerElem.textContent === '00m 00s') {
							btn.classList.add('disabled');
							btn.setAttribute('aria-disabled', 'true');
							btn.style.pointerEvents = 'none';
							btn.style.opacity = '0.6';
						} else {
							btn.classList.remove('disabled');
							btn.removeAttribute('aria-disabled');
							btn.style.pointerEvents = '';
							btn.style.opacity = '';
						}
					});
					var viewCartBtn = document.getElementById('view_cart_and_checkout');
					if (viewCartBtn) {
						if (timerElem.textContent === '00m 00s') {
							viewCartBtn.classList.add('disabled');
							viewCartBtn.setAttribute('aria-disabled', 'true');
							viewCartBtn.style.pointerEvents = 'none';
							viewCartBtn.style.opacity = '0.6';
						} else {
							viewCartBtn.classList.remove('disabled');
							viewCartBtn.removeAttribute('aria-disabled');
							viewCartBtn.style.pointerEvents = '';
							viewCartBtn.style.opacity = '';
						}
					}
                }
            }
        }
        updateTimer_<?php echo $item['id']; ?>();
        setInterval(updateTimer_<?php echo $item['id']; ?>, 1000);
    })();
    <?php endif; } ?>
</script>