<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php hooks()->do_action('head_element_client'); ?>
<div>
    <div class="row">        <div class="col-md-4 col-sm-6 col-xs-6">
            <select name="product_categories" class="form-control selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('products_categories'); ?>" data-live-search="true">
                <option value="0"><?php echo _l('All Product Categories'); ?></option>
                <?php foreach ($group_product as $key => $value) { 
                    if($this->omni_sales_model->has_product_cat(2,$value['id'])){ ?>
                        <option value="<?php echo $value['id']; ?>" <?php echo ($value['id'] == $group_id) ? 'selected' : ''; ?>>
                            <?php echo html_entity_decode($value['name']); ?>
                        </option>
                    <?php } 
                } ?>
            </select>
        </div>
        <div class="col-md-8 col-sm-6 col-xs-6">
            <a id="view_cart_and_checkout" href="<?php echo is_client_logged_in() ? site_url('omni_sales/omni_sales_client/view_overview') : site_url('authentication/login'); ?>" class="btn btn-success pull-right">
                <i class="fa fa-shopping-cart"></i> <?php echo _l('view_cart_and_checkout'); ?>
            </a>
        </div>
    </div>
</div>
<br>
<div class="row">
    <div class="col-md-12 text-center no_product hidden">
        <br><br><img src="<?php echo base_url('assets/images/no-product.png'); ?>" class="img1 img-responsive">    </div>
    <div id="filter_html">
        <?php 
        // Fix: Create the data array from available variables
        $data = [
            'product'       => isset($product) ? $product : [],
            'total_page'    => isset($total_page) ? $total_page : 0,
            'page'          => isset($page) ? $page : 1,
            'group_id'      => isset($group_id) ? $group_id : 0,
            'group_product' => isset($group_product) ? $group_product : [],
            'title_group'   => isset($title_group) ? $title_group : '',
            'base_currency' => isset($base_currency) ? $base_currency : null,
            // Add bakery config
            'special_dates' => isset($special_dates) ? $special_dates : [],
            'monday_start_time' => isset($monday_start_time) ? $monday_start_time : '',
            'monday_end_time' => isset($monday_end_time) ? $monday_end_time : '',
            'tuesday_start_time' => isset($tuesday_start_time) ? $tuesday_start_time : '',
            'tuesday_end_time' => isset($tuesday_end_time) ? $tuesday_end_time : '',
            'wednesday_start_time' => isset($wednesday_start_time) ? $wednesday_start_time : '',
            'wednesday_end_time' => isset($wednesday_end_time) ? $wednesday_end_time : '',
            'thursday_start_time' => isset($thursday_start_time) ? $thursday_start_time : '',
            'thursday_end_time' => isset($thursday_end_time) ? $thursday_end_time : '',
            'friday_start_time' => isset($friday_start_time) ? $friday_start_time : '',
            'friday_end_time' => isset($friday_end_time) ? $friday_end_time : '',
            'saturday_start_time' => isset($saturday_start_time) ? $saturday_start_time : '',
            'saturday_end_time' => isset($saturday_end_time) ? $saturday_end_time : '',
            'sunday_start_time' => isset($sunday_start_time) ? $sunday_start_time : '',
            'sunday_end_time' => isset($sunday_end_time) ? $sunday_end_time : '',
            'portal_row_product_show' => isset($portal_row_product_show) ? $portal_row_product_show : "", // Default to 2 for consistency
            'portal_page_product_show' => isset($portal_page_product_show) ? $portal_page_product_show : "", // Default to 6 if not set
        ];
        $this->load->view('omni_sales/client/list_product/list_product_with_page', $data);
        ?>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="pull-right">
            <?php if ($total_page > 1): ?>
                <?php
                    $range = 5;
                    $start = max(1, $page - floor($range/2));
                    $end = min($total_page, $start + $range - 1);
                    if ($end - $start < $range - 1) {
                        $start = max(1, $end - $range + 1);
                    }
                ?>
                <nav aria-label="Product pagination">
                    <ul class="pagination">
                        <!-- First page and left arrow -->
                        <?php if ($start > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo site_url('products/1/' . $group_id); ?>">&laquo;</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo site_url('products/' . ($start - 1) . '/' . $group_id); ?>">&lt;</a>
                            </li>
                        <?php endif; ?>

                        <!-- Page numbers -->
                        <?php for ($i = $start; $i <= $end; $i++): ?>
                            <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                <a class="page-link" href="<?php echo site_url('products/' . $i . '/' . $group_id); ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>

                        <!-- Right arrow and last page -->
                        <?php if ($end < $total_page): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo site_url('products/' . ($end + 1) . '/' . $group_id); ?>">&gt;</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo site_url('products/' . $total_page . '/' . $group_id); ?>">&raquo;</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Handle category selection change  
    $('select[name="product_categories"]').on('change', function() {
        var group_id = $(this).val() || 0;
        
        // Reload the page with the selected category
        window.location.href = '<?php echo site_url("omni_sales/omni_sales_client/index/1/"); ?>' + group_id + '/0';
    });
});
</script>

<div class="modal fade" id="alert_add" tabindex="-1" role="dialog">
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-body">
        	<div class="row">
	        	<div class="col-md-12 alert_content">
	        		<div class="clearfix"></div>
	        		<br>
	        		<br>
	        		<center class="add_success hide"><h4><?php echo _l('successfully_added'); ?></h4></center>
	        		<center class="add_error hide"><h4><?php echo _l('sorry_the_number_of_current_products_is_not_enough'); ?></h4></center>
	        		<br>
	        		<br>
					<div class="clearfix"></div>
	        	</div>
        	</div>
        </div>              
  	</div>
</div>
</div>

<?php hooks()->do_action('client_pt_footer_js'); ?>


