<style>
    .ecom-table-header {
        background: linear-gradient(90deg, #ffb347 0%, #ffcc80 100%);
        color: #fff;
        padding: 10px 0;
        border-radius: 8px 8px 0 0;
        margin-bottom: 0;
        font-size: 16px;
        font-weight: 600;
        letter-spacing: 1px;
        display: flex;
        align-items: center;
    }
    .ecom-row {
        background: #fff8e1;
        border-bottom: 1px solid #ffe0b2;
        border-radius: 0 0 8px 8px;
        margin-bottom: 8px;
        padding: 8px 0;
        align-items: center;
        transition: box-shadow 0.2s;
        display: flex;
    }
    .ecom-row:hover {
        box-shadow: 0 2px 8px rgba(255, 179, 71, 0.08);
        background: #fff3e0;
    }
    .ecom-label {
        font-weight: 500;
        font-size: 15px;
        display: flex;
        align-items: center;
    }
    .ecom-label .bakery-icon {
        margin-right: 8px;
        font-size: 20px;
        color: #ff9800;
    }
    .form-control[type="time"], .form-control[type="date"] {
        border: 1px solid #ffb347;
        border-radius: 6px;
        background: #fff;
        color: #a67c52;
        font-size: 15px;
        box-shadow: none;
    }
    .btn-default {
        background: #ff9800;
        color: #fff;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        transition: background 0.2s;
        margin-top: 10px;
    }
    .btn-default:hover {
        background: #fb8c00;
        color: #fff;
    }
    .btn-primary {
        background: #a67c52;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        transition: background 0.2s;
    }
    .btn-primary:hover {
        background: #8d6e63;
    }
    .special-date-row {
        margin-bottom: 8px;
        display: flex;
    }
    h5 {
        color: #ff9800;
        font-weight: 600;
        margin-top: 30px;
    }
    .bakery-icon {
        display: inline-block;
        width: 24px;
        height: 24px;
        vertical-align: middle;
    }
</style>
<div class="panel_s">
    <div class="panel-body">
        <h4>
            <span class="bakery-icon">
                <!-- Simple bakery SVG icon (bread) -->
                <svg viewBox="0 0 24 24" width="24" height="24">
                    <ellipse cx="12" cy="12" rx="10" ry="6" fill="#ffb347" stroke="#a67c52" stroke-width="2"/>
                    <ellipse cx="12" cy="12" rx="8" ry="4.5" fill="#fff3e0"/>
                    <path d="M6 12 Q8 14 12 14 Q16 14 18 12" stroke="#a67c52" stroke-width="1" fill="none"/>
                </svg>
            </span>
            Portal Order Time Configuration
        </h4>
        <hr>
        <?php echo form_open(admin_url('omni_sales/save_ecom_config'), array('id' => 'ecom-config-form')); ?>
        <div class="row ecom-table-header">
            <div class="col-md-4" style="display:flex;align-items:center;">
                <span class="bakery-icon">
                    <svg viewBox="0 0 24 24" width="24" height="24">
                        <ellipse cx="12" cy="12" rx="10" ry="6" fill="#ffb347" stroke="#a67c52" stroke-width="2"/>
                        <ellipse cx="12" cy="12" rx="8" ry="4.5" fill="#fff3e0"/>
                    </svg>
                </span>
                Days
            </div>
            <div class="col-md-4"><span class="bakery-icon">
                <svg width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" fill="#ffb347"/><rect x="11" y="7" width="2" height="6" fill="#a67c52"/><rect x="11" y="13" width="2" height="4" fill="#a67c52"/></svg>
            </span> Start Time</div>
            <div class="col-md-4"><span class="bakery-icon">
                <svg width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" fill="#ffb347"/><rect x="11" y="7" width="2" height="10" fill="#a67c52"/></svg>
            </span> End Time</div>
        </div>
        <?php
        $weekdays = [
            'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'
        ];
        foreach ($weekdays as $day): ?>
            <div class="row ecom-row">
                <div class="col-md-4 ecom-label">
                    <span class="bakery-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <ellipse cx="12" cy="12" rx="10" ry="6" fill="#ffb347" stroke="#a67c52" stroke-width="2"/>
                            <ellipse cx="12" cy="12" rx="8" ry="4.5" fill="#fff3e0"/>
                        </svg>
                    </span>
                    <?php echo ucfirst($day); ?>
                </div>
                <div class="col-md-4">
                    <input type="time" name="<?php echo $day; ?>_start_time" class="form-control"
                           value="<?php echo isset(${$day . '_start_time'}) ? ${$day . '_start_time'} : ''; ?>"
                           placeholder="Start Time">
                </div>
                <div class="col-md-4">
                    <input type="time" name="<?php echo $day; ?>_end_time" class="form-control"
                           value="<?php echo isset(${$day . '_end_time'}) ? ${$day . '_end_time'} : ''; ?>"
                           placeholder="End Time">
                </div>
            </div>
        <?php endforeach; ?>
        <hr>
        <h5>
            <span class="bakery-icon">
                <svg viewBox="0 0 24 24" width="24" height="24">
                    <ellipse cx="12" cy="12" rx="10" ry="6" fill="#ffb347" stroke="#a67c52" stroke-width="2"/>
                    <ellipse cx="12" cy="12" rx="8" ry="4.5" fill="#fff3e0"/>
                </svg>
            </span>
            Special Dates
        </h5>
        <div class="row ecom-table-header">
            <div class="col-md-4"><span class="bakery-icon">
                <svg viewBox="0 0 24 24" width="24" height="24">
                    <rect x="4" y="6" width="16" height="14" rx="2" fill="#ffb347" stroke="#a67c52" stroke-width="2"/>
                    <rect x="7" y="9" width="10" height="8" rx="1" fill="#fff3e0"/>
                </svg>
            </span> Date</div>
            <div class="col-md-4"><span class="bakery-icon">
                <svg width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" fill="#ffb347"/><rect x="11" y="7" width="2" height="6" fill="#a67c52"/><rect x="11" y="13" width="2" height="4" fill="#a67c52"/></svg>
            </span> Start Time</div>
            <div class="col-md-4"><span class="bakery-icon">
                <svg width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" fill="#ffb347"/><rect x="11" y="7" width="2" height="10" fill="#a67c52"/></svg>
            </span> End Time</div>
        </div>
        <div id="special-dates-container">
            <?php
            if (!empty($special_dates)) {
                foreach ($special_dates as $idx => $row) { ?>
                    <div class="row special-date-row ecom-row">
                        <div class="col-md-4">
                            <input type="date" name="special_dates[<?php echo $idx; ?>][date]" class="form-control"
                                value="<?php echo htmlspecialchars($row['date']); ?>">
                        </div>
                        <div class="col-md-4">
                            <input type="time" name="special_dates[<?php echo $idx; ?>][start_time]" class="form-control"
                                value="<?php echo htmlspecialchars($row['start_time']); ?>" placeholder="Start Time">
                        </div>
                        <div class="col-md-4">
                            <input type="time" name="special_dates[<?php echo $idx; ?>][end_time]" class="form-control"
                                value="<?php echo htmlspecialchars($row['end_time']); ?>" placeholder="End Time">
                        </div>
                    </div>
            <?php }
            } else { ?>
                <div class="row special-date-row ecom-row">
                    <div class="col-md-4">
                        <input type="date" name="special_dates[0][date]" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <input type="time" name="special_dates[0][start_time]" class="form-control" placeholder="Start Time">
                    </div>
                    <div class="col-md-4">
                        <input type="time" name="special_dates[0][end_time]" class="form-control" placeholder="End Time">
                    </div>
                </div>
            <?php } ?>
        </div>
        <button type="button" class="btn btn-default" onclick="addSpecialDateRow();">
            <span class="bakery-icon">
                <svg width="20" height="20" viewBox="0 0 20 20"><circle cx="10" cy="10" r="10" fill="#ffb347"/><rect x="9" y="5" width="2" height="10" fill="#a67c52"/><rect x="5" y="9" width="10" height="2" fill="#a67c52"/></svg>
            </span>
            Add Special Date
        </button>
        <div class="row" style="margin-top: 20px;">
            <div class="col-md-12 text-right">
                <button type="submit" class="btn btn-primary">
                    <span class="bakery-icon">
                        <svg width="20" height="20" viewBox="0 0 20 20"><rect x="4" y="8" width="12" height="8" rx="2" fill="#ffb347" stroke="#a67c52" stroke-width="1"/><rect x="7" y="11" width="6" height="3" rx="1" fill="#fff3e0"/></svg>
                    </span>
                    Save
                </button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>
<script>
function addSpecialDateRow() {
    var idx = document.querySelectorAll('.special-date-row').length;
    var html = `<div class="row special-date-row ecom-row">
        <div class="col-md-4">
            <input type="date" name="special_dates[${idx}][date]" class="form-control">
        </div>
        <div class="col-md-4">
            <input type="time" name="special_dates[${idx}][start_time]" class="form-control" placeholder="Start Time">
        </div>
        <div class="col-md-4">
            <input type="time" name="special_dates[${idx}][end_time]" class="form-control" placeholder="End Time">
        </div>
    </div>`;
    document.getElementById('special-dates-container').insertAdjacentHTML('beforeend', html);
}
</script>