<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Receipe_managements_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get recipe products
     * @return [type] 
     */
    public function get_recipe_products()
    {
        $products = [];
        $result = $this->db->get(db_prefix() . 'ItemReceipe')->result_array();
        
        foreach ($result as $row) {
            $products[] = [
                'id' => $row['id'],
                'name' => $row['description'],
            ];
        }
        
        return $products;
    }

    /**
     * Get product component data
     * @param  [type] $product_id 
     * @param  [type] $qty        
     * @return [type]             
     */
    public function get_product_component($product_id, $qty = 1, $dayType = '1-2')
    {
        
        // Step 1: Build map of component_id => name
        $compMap = [];
        //$compRes = $this->db->get(db_prefix() . 'tblReceipeItemComponent');
		$compRes = $this->db->get(db_prefix() . 'itemcomponent');
        if ($compRes) {
            foreach ($compRes->result_array() as $row) {
                $compMap[$row['id']] = isset($row['name']) ? $row['name'] : 'Component ' . $row['id'];
            }
        }
		//var_dump($compMap);die;

        // Step 2: Fetch all component entries for this product
        $this->db->where('product_id', $product_id);
        $this->db->where('day_type', $dayType);
        $this->db->order_by('id', 'DESC');
        $result = $this->db->get(db_prefix() . 'ReceipeItemComponent');
		
        $components_by_day = [];
        if ($result && $result->num_rows() > 0) {
            foreach ($result->result_array() as $row) {
                $day_type = $row['day_type'];

                // Parse and enrich component data
                $groups = ['levain', 'autolyse', 'seed_mix'];
                foreach ($groups as $group) {
                    $json = json_decode($row[$group], true) ?: [];
                    foreach ($json as &$comp) {
                        $comp_id = $comp['component_id'];
                        $comp['name'] = isset($compMap[$comp_id]) ? $compMap[$comp_id] : "ID $comp_id";
                    }
                    $components_by_day[$day_type][$group] = $json;
                }
            }

            // Step 3: Get product description
            $product = [
                'description' => '',
                'day_type' => implode(', ', array_keys($components_by_day))
            ];
            $this->db->where('id', $product_id);
            $prodRes = $this->db->get(db_prefix() . 'ItemReceipe');
            if ($prodRes && $prodRow = $prodRes->row_array()) {
                $product['description'] = $prodRow['description'];
            }

            return [
                'success' => true,
                'product' => $product,
                'components_by_day' => $components_by_day
            ];
        } else {
            return [
                'success' => false, 
                'message' => 'No component data found for this product'
            ];
        }
    }

    /**
     * Get components for dropdown
     * @return [type] 
     */
    public function get_components()
    {
        $components = [];
        $result = $this->db->get(db_prefix() . 'itemcomponent')->result_array();
        
        foreach ($result as $row) {
            $components[] = [
                'id' => $row['id'],
                'name' => $row['name']
            ];
        }
        
        return $components;
    }

    /**
     * Save recipe data
     * @param  [type] $data 
     * @return [type]       
     */
    public function save_recipe($data)
    {
        $product_id = intval($data['product_id']);
        $day_type = $this->db->escape_str($data['day']);

        // Group components by label
        $levain = [];
        $autolyse = [];
        $seed_mix = [];

        foreach ($data['components'] as $comp) {
            $entry = [
                'component_id' => intval($comp['component_id']),
                'quantity' => $comp['quantity'],
                'unit' => $comp['unit']
            ];
            if ($comp['label'] === 'LEVAIN') {
                $levain[] = $entry;
            } elseif ($comp['label'] === 'AUTOLYSE') {
                $autolyse[] = $entry;
            } elseif ($comp['label'] === 'SEED MIX') {
                $seed_mix[] = $entry;
            }
        }

        // Prepare reusable variables
        $staff_user_id = get_staff_user_id();
        $staff_full_name = get_staff_full_name($staff_user_id);
        $now = date('Y-m-d H:i:s');

        // Check if recipe already exists for this product and day type
        $this->db->where('product_id', $product_id);
        $this->db->where('day_type', $day_type);
        $existing = $this->db->get(db_prefix() . 'ReceipeItemComponent');

        $insert_data = [
            'product_id' => $product_id,
            'levain' => json_encode($levain),
            'autolyse' => json_encode($autolyse),
            'seed_mix' => json_encode($seed_mix),
            'day_type' => $day_type,
            'updated_at' => $now,
            'created_by' => $staff_full_name,
            'user_id' => $staff_user_id,
            'created_at' => $now
        ];
        $updated_data = [
            'product_id' => $product_id,
            'levain' => json_encode($levain),
            'autolyse' => json_encode($autolyse),
            'seed_mix' => json_encode($seed_mix),
            'day_type' => $day_type,
            'updated_at' => $now,
        ];

        if ($existing && $existing->num_rows() > 0) {
            // Store in log
            $this->db->insert('tblrecipe_log', [
                'user_id' => $staff_user_id,
                'module' => 'Recipe',
                'action' => 'update_recipe',
                'details' => json_encode([
                    'product_id' => $product_id,
                    'levain' => $levain,
                    'autolyse' => $autolyse,
                    'seed_mix' => $seed_mix,
                    'day_type' => $day_type
                ]),
                'created_at' => $now,
                'created_by' => $staff_full_name
            ]);
            // Update existing recipe
            $this->db->where('product_id', $product_id);
            $this->db->where('day_type', $day_type);
            if ($this->db->update(db_prefix() . 'ReceipeItemComponent', $updated_data)) {
                return ['success' => true, 'message' => 'Recipe updated successfully'];
            } else {
                return ['success' => false, 'message' => 'Update failed: ' . $this->db->error()['message']];
            }
        } else {
            // Insert new recipe
            if ($this->db->insert(db_prefix() . 'ReceipeItemComponent', $insert_data)) {
                // Store in log
                $this->db->insert('tblrecipe_log', [
                    'user_id' => $staff_user_id,
                    'module' => 'Recipe',
                    'action' => 'create_recipe',
                    'details' => json_encode([
                        'product_id' => $product_id,
                        'levain' => $levain,
                        'autolyse' => $autolyse,
                        'seed_mix' => $seed_mix,
                        'day_type' => $day_type
                    ]),
                    'created_at' => $now,
                    'created_by' => $staff_full_name
                ]);
                return ['success' => true, 'message' => 'Recipe saved successfully'];
            } else {
                return ['success' => false, 'message' => 'Insert failed: ' . $this->db->error()['message']];
            }
        }
    }

    /**
     * Add product to ItemReceipe table
     * @param array $datas Data to insert (associative array)
     * @return int|false   Inserted ID on success, false on failure
     */
    public function add_itemReceipe($datas)
    {
        $this->db->insert(db_prefix() . 'ItemReceipe', $datas);
        return $this->db->insert_id();
    }

    /**
     * Check format date Y-m-d
     * @param  String $date The date
     * @return boolean 
     */
    public function check_format_date($date)
    {
        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Add product (only description)
     * @param  array $data ['description' => ...]
     * @return int|false   Inserted ID or false on failure
     */
    public function add_product($data)
    {
        // Only keep the description field
        $insert = [
            'description' => isset($data['description']) ? $data['description'] : null
        ];
        $this->db->insert(db_prefix() . 'ItemReceipe', $insert);
        return $this->db->insert_id();
    }

    public function get_groups()
    {
        $this->db->select('id, day_shift');
        $result = $this->db->get(db_prefix() . 'itemrecipegroup');

        if ($result && $result->num_rows() > 0) {
            return $result->result_array();
        } else {
            return [];
        }
    }

    public function get_groups_byid($dayType)
    {
        $this->db->where('id', $dayType);
        $result = $this->db->get(db_prefix() . 'itemrecipegroup');

        if ($result && $result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return [];
        }
    }

    public function add_day_shift($datas)
    {
        $this->db->insert(db_prefix() . 'itemrecipegroup', $datas);
        return $this->db->insert_id();

    }
    
}