<?php

defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: Receipe Managements
Description: Manage receipes and related operations
Version: 1.0.0
Requires at least: 2.3.*
Author: Your Name
Author URI: https://yourdomain.com
*/

define('RECEIPE_MANAGEMENTS_MODULE_NAME', 'receipe_managements');
define('RECEIPE_MANAGEMENTS_MODULE_UPLOAD_FOLDER', module_dir_path(RECEIPE_MANAGEMENTS_MODULE_NAME, 'uploads'));
hooks()->add_action('app_admin_head', 'receipe_managements_add_head_component');
hooks()->add_action('app_admin_footer', 'receipe_managements_load_js');
hooks()->add_action('admin_init', 'receipe_managements_permissions');
define('RECEIPE_MANAGEMENTS_PATH', 'modules/receipe_managements/uploads/');
define('RECEIPE_MANAGEMENTS_APP_PATH', 'modules/receipe_managements/');
hooks()->add_action('admin_init', 'receipe_managements_module_init_menu_items');

define('VERSION_RECEIPT', 1052);

// Add your helper, permissions, menu, etc. here

/**
 * Register activation module hook
 */
register_activation_hook(RECEIPE_MANAGEMENTS_MODULE_NAME, 'receipe_managements_module_activation_hook');
function receipe_managements_module_activation_hook()
{
	$CI = &get_instance();
	require_once(__DIR__ . '/install.php');
}
/**
* Register language files, must be registered if the module is using languages
*/
register_language_files(RECEIPE_MANAGEMENTS_MODULE_NAME, [RECEIPE_MANAGEMENTS_MODULE_NAME]);


$CI = & get_instance();
$CI->load->helper(RECEIPE_MANAGEMENTS_MODULE_NAME . '/Receipe_managements');

function receipe_managements_permissions()
{
    $capabilities = [];
    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('receipe_managements', $capabilities, _l('receipe_managements'));
}

/**
	 * manufacturing load js
	 */
	function receipe_managements_load_js(){    
		$CI = &get_instance();    
		$viewuri = $_SERVER['REQUEST_URI'];
		

	}

    /**
	 * manufacturing add head components
	 */
	function receipe_managements_add_head_component(){    
		$CI = &get_instance();
		$viewuri = $_SERVER['REQUEST_URI'];

		if (strpos($viewuri, 'admin/receipe_managements') !== false) {
			echo '<link href="' . module_dir_url(RECEIPE_MANAGEMENTS_MODULE_NAME, 'assets/css/styles.css') . '?v=' . VERSION_RECEIPT. '"  rel="stylesheet" type="text/css" />';
		}

		if (strpos($viewuri, 'admin/receipe_managements/recipe_management') !== false) {
			echo '<link href="' . module_dir_url(RECEIPE_MANAGEMENTS_MODULE_NAME, 'assets/css/recipe_management.css') . '?v=' . VERSION_RECEIPT. '"  rel="stylesheet" type="text/css" />';
		}

		if (strpos($viewuri, 'admin/receipe_managements/add_recipe') !== false) {
			echo '<link href="' . module_dir_url(RECEIPE_MANAGEMENTS_MODULE_NAME, 'assets/css/add_recipe.css') . '?v=' . VERSION_RECEIPT. '"  rel="stylesheet" type="text/css" />';
		}

		if (strpos($viewuri, 'admin/receipe_managements/products') !== false) {
			echo '<link href="' . module_dir_url(RECEIPE_MANAGEMENTS_MODULE_NAME, 'assets/css/products.css') . '?v=' . VERSION_RECEIPT. '"  rel="stylesheet" type="text/css" />';
		}
	}


/**
 * Init Receipe Managements module menu items in setup in admin_init hook
 */
function receipe_managements_module_init_menu_items()
{
    $CI = &get_instance();

    if (has_permission('receipe_managements', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('receipe_managements', [
            'name'     => _l('recipes'),
            'icon'     => 'fa fa-book',
            'position' => 35,
            'href'     => admin_url('receipe_managements'),
        ]);

        $CI->app_menu->add_sidebar_children_item('receipe_managements', [
			'slug'     => 'manufacturing_recipe_management',
			'name'     => _l('recipe_management'),
			'icon'     => 'fa fa-genderless',
			'href'     => admin_url('receipe_managements/recipe_management'),
			'position' => 9.5,
		]);

        $CI->app_menu->add_sidebar_children_item('receipe_managements', [
			'slug'     => 'manufacturing_add_recipe',
			'name'     => _l('add_recipe'),
			'icon'     => 'fa fa-genderless',
			'href'     => admin_url('receipe_managements/add_recipe'),
			'position' => 10,
		]);

		$CI->app_menu->add_sidebar_children_item('receipe_managements', [
			'slug'     => 'receipe_products',
			'name'     => _l('products'),
			'icon'     => 'fa fa-genderless',
			'href'     => admin_url('receipe_managements/products'),
			'position' => 11,
		]);
    }
}
