<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        
                        <div style="display: flex; justify-content: center; align-items: center;">
                            <div class="add-product-section-title" style="margin-bottom: 18px; display: flex; align-items: center;">
                                <span class="page-heading-icon" style="margin-right: 10px;">
                                    <i class="fa fa-plus-circle"></i>
                                </span>
                                <h3 style="margin:0; font-size: 18px; font-weight: 400;"><?php echo _l('add_recipe'); ?></h3>
                            </div>
                        </div>
                        
                        <div class="container">
                            <div class="add-product-section">
                                <form id="addRecipeForm">
                                    <!-- Product and Day Selection in the same row -->
                                    <div style="display: flex; gap: 12px; margin-bottom: 12px;">
                                        <div style="flex:2; display:flex; flex-direction:column;">
                                            <label for="productSelect" style="margin-bottom:4px;"><?php echo _l('select_product'); ?></label>
                                            <select id="productSelect" required></select>
                                        </div>
                                        <div style="flex:1; display:flex; flex-direction:column;">
                                            <label for="daySelect" style="margin-bottom:4px;"><?php echo _l('select_day'); ?></label>
                                            <select id="daySelect" required></select>
                                        </div>
                                    </div>
                                    
                                    <!-- Components -->
                                    <div id="componentsContainer">
                                        <!-- LEVAIN Group -->
                                        <div class="component-group" id="levain-group">
                                            <div style="display: flex; align-items: center; margin-bottom:6px;">
                                                <span style="font-weight:bold; flex:1;"><?php echo _l('levain'); ?></span>
                                                <button type="button" onclick="addComponentField('levain-group', 'LEVAIN')" title="<?php echo _l('add_component'); ?>" style="margin-left:12px; font-size:1.3em; background:none; border:none; color:#3182ce; cursor:pointer;">
                                                    <span aria-label="Add" style="font-size:1.3em;">+</span>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <!-- AUTOLYSE Group -->
                                        <div class="component-group" id="autolyse-group">
                                            <div style="display: flex; align-items: center; margin-bottom:6px;">
                                                <span style="font-weight:bold; flex:1;"><?php echo _l('autolyse'); ?></span>
                                                <button type="button" onclick="addComponentField('autolyse-group', 'AUTOLYSE')" title="<?php echo _l('add_component'); ?>" style="margin-left:12px; font-size:1.3em; background:none; border:none; color:#3182ce; cursor:pointer;">
                                                    <span aria-label="Add" style="font-size:1.3em;">+</span>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <!-- SEED MIX Group -->
                                        <div class="component-group" id="seedmix-group">
                                            <div style="display: flex; align-items: center; margin-bottom:6px;">
                                                <span style="font-weight:bold; flex:1;"><?php echo _l('seed_mix'); ?></span>
                                                <button type="button" onclick="addComponentField('seedmix-group', 'SEED MIX')" title="<?php echo _l('add_component'); ?>" style="margin-left:12px; font-size:1.3em; background:none; border:none; color:#3182ce; cursor:pointer;">
                                                    <span aria-label="Add" style="font-size:1.3em;">+</span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="add-product-buttons">
                                        <button type="submit" style="background:#2b6cb0; color:#fff; border:none; border-radius:6px; padding:10px 20px; font-size:1em; cursor:pointer;">
                                            <?php echo _l('save_recipe'); ?>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal HTML -->
<div id="addProductModal" class="modal">
    <div class="modal-content">
        <button type="button" id="closeAddProductModal" class="modal-close" aria-label="Close">&times;</button>
        <h3 class="modal-title"><?php echo _l('add_new_product'); ?></h3>
        <form id="addProductForm">
            <div class="modal-form-group">
                <label for="newProductName" class="modal-label"><?php echo _l('product_name'); ?></label>
                <input type="text" id="newProductName" class="modal-input" required>
                <div id="newProductNameError" class="error-message"></div>
            </div>
            <div class="modal-actions">
                <button type="submit" class="btn btn-primary modal-save-btn"><?php echo _l('save'); ?></button>
            </div>
        </form>
    </div>
</div>

<!-- Modal for Add New Day Shift -->
<div id="addDayShiftModal" class="modal">
    <div class="modal-content">
        <button type="button" id="closeAddDayShiftModal" class="modal-close" aria-label="Close">&times;</button>
        <h3 class="modal-title"><?php echo _l('create_new_day_shift'); ?></h3>
        <form id="addDayShiftForm">
            <div class="modal-form-group">
                <label for="newDayShiftName" class="modal-label"><?php echo _l('day_shift_name'); ?></label>
                <input type="text" id="newDayShiftName" class="modal-input" required>
                <div id="newDayShiftNameError" class="error-message"></div>
            </div>
            <div class="modal-actions">
                <button type="submit" class="btn btn-primary modal-save-btn"><?php echo _l('save'); ?></button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let componentOptions = [];

    // Load products and components on page load
    loadProducts();
    loadComponents();
    loadDayTypes();

    function loadProducts(selectedId = null) {
        fetch('<?php echo admin_url('receipe_managements/get_recipe_products'); ?>')
            .then(response => response.json())
            .then(data => {
                const productSelect = document.getElementById('productSelect');
                productSelect.innerHTML = '';

                // 1. "Create New Product" option
                const createOption = document.createElement('option');
                createOption.value = '__add_new__';
                createOption.textContent = '<?php echo _l('create_new_product'); ?>';
                productSelect.appendChild(createOption);

                // 2. Separator (disabled)
                const separator = document.createElement('option');
                separator.disabled = true;
                separator.textContent = '';
                productSelect.appendChild(separator);

                // 3. Product options
                data.forEach(product => {
                    const option = document.createElement('option');
                    option.value = product.id;
                    option.textContent = product.name;
                    productSelect.appendChild(option);
                });

                // If a product should be selected (after adding), select it
                if (selectedId) {
                    productSelect.value = selectedId;
                } else {
                    productSelect.value = ''; // Nothing selected by default
                }
            })
            .catch(error => {
                console.error('Error loading products:', error);
            });
    }

    function loadComponents() {
        fetch('<?php echo admin_url('receipe_managements/get_components'); ?>')
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    componentOptions = data.components;
                    // Add initial rows for each group
                    addComponentField('levain-group', 'LEVAIN');
                    addComponentField('autolyse-group', 'AUTOLYSE');
                    addComponentField('seedmix-group', 'SEED MIX');
                }
            })
            .catch(error => {
                console.error('Error loading components:', error);
            });
    }

    function loadDayTypes(selectedId = null) {
        fetch('<?php echo admin_url('receipe_managements/get_recipe_groups'); ?>')
            .then(response => response.json())
            .then(data => {
                const daySelect = document.getElementById('daySelect');
                daySelect.innerHTML = '';

                // 1. "Create New Day Shift" option
                const createDayOption = document.createElement('option');
                createDayOption.value = '__add_new_day__';
                createDayOption.textContent = '<?php echo _l('create_new_shift'); ?>';
                daySelect.appendChild(createDayOption);

                // 2. Separator (disabled)
                const daySeparator = document.createElement('option');
                daySeparator.disabled = true;
                daySeparator.textContent = '';
                daySelect.appendChild(daySeparator);

                // 3. Day shift options
                data.forEach(day => {
                    const dayOption = document.createElement('option');
                    dayOption.value = day.day_shift;
                    dayOption.textContent = day.day_shift;
                    daySelect.appendChild(dayOption);
                });

                // If a day shift should be selected (after adding), select it
                if (selectedId) {
                    daySelect.value = selectedId;
                } else {
                    daySelect.value = ''; // Nothing selected by default
                }
            })
            .catch(error => {
                console.error('Error loading components:', error);
            });
    }

    window.addComponentField = function(groupId, groupLabel) {
        const group = document.getElementById(groupId);
        
        const row = document.createElement('div');
        row.className = 'component-row';

        const nameSelect = document.createElement('select');
        nameSelect.className = 'componentName';
        nameSelect.innerHTML = '<option value=""><?php echo _l('component'); ?></option>';
        componentOptions.forEach(comp => {
            const opt = document.createElement('option');
            opt.value = comp.id;
            opt.textContent = comp.name;
            nameSelect.appendChild(opt);
        });

        const qtyInput = document.createElement('input');
        qtyInput.type = 'text';
        qtyInput.className = 'componentQty';
        qtyInput.placeholder = '<?php echo _l('quantity'); ?>';

        const unitSelect = document.createElement('select');
        unitSelect.className = 'componentUnit';
        unitSelect.innerHTML = `
            <option value=""><?php echo _l('unit'); ?></option>
            <option value="kg">kg</option>
            <option value="g">g</option>
            <option value="ml">ml</option>
            <option value="pcs">pcs</option>
            <option value="litre">litre</option>
        `;

        const delBtn = document.createElement('button');
        delBtn.type = 'button';
        delBtn.className = 'delete-component-btn';
        delBtn.title = '<?php echo _l('delete_component'); ?>';
        delBtn.innerHTML = '🗑️';
        delBtn.onclick = function () {
            row.remove();
            updateDeleteButtons();
        };

        row.appendChild(nameSelect);
        row.appendChild(qtyInput);
        row.appendChild(unitSelect);
        row.appendChild(delBtn);

        group.appendChild(row);
        updateDeleteButtons();
    }

    function updateDeleteButtons() {
        // For each group, show delete button only if more than one row
        ['levain-group', 'autolyse-group', 'seedmix-group'].forEach(groupId => {
            const group = document.getElementById(groupId);
            const rows = group.querySelectorAll('.component-row');
            rows.forEach((row, idx) => {
                const btn = row.querySelector('.delete-component-btn');
                if (btn) {
                    btn.style.display = (rows.length >= 1) ? '' : 'none';
                }
            });
        });
    }

    function collectComponents(groupId, label) {
        const group = document.getElementById(groupId);
        return Array.from(group.querySelectorAll('.component-row')).map(row => {
            const nameEl = row.querySelector('.componentName');
            const qtyEl = row.querySelector('.componentQty');
            const unitEl = row.querySelector('.componentUnit');
            return {
                label,
                component_id: nameEl ? nameEl.value : '',
                quantity: qtyEl ? qtyEl.value : '',
                unit: unitEl ? unitEl.value : ''
            };
        });
    }

    document.getElementById('addRecipeForm').addEventListener('submit', function (e) {
        e.preventDefault();
        const productId = document.getElementById('productSelect').value;
        const dayValue = document.getElementById('daySelect').value;

        // Collect components from all groups
        const levainComponents = collectComponents('levain-group', 'LEVAIN');
        const autolyseComponents = collectComponents('autolyse-group', 'AUTOLYSE');
        const seedmixComponents = collectComponents('seedmix-group', 'SEED MIX');
        const components = [...levainComponents, ...autolyseComponents, ...seedmixComponents];

        // Remove empty components and set default values for quantity and unit
        const filteredComponents = components
            .filter(c => c.component_id) // Remove if component is empty
            .map(c => ({
                ...c,
                quantity: c.quantity ? c.quantity : "0",
                unit: c.unit ? c.unit : "g"
            }));

        console.log("Filtered Components:", filteredComponents);

        let missing = false;
        filteredComponents.forEach((c, idx) => {
            if (!c.component_id || !c.quantity || !c.unit) {
                missing = true;
                console.warn(`Missing field in component row ${idx + 1}:`, c);
            }
        });
        
        if (!productId) {
            alert('<?php echo _l('please_select_product'); ?>');
            return;
        } else if (!dayValue) {
            alert('<?php echo _l('please_select_day'); ?>');
            return;
        } else if (missing) {
            alert('<?php echo _l('please_fill_all_fields'); ?>');
            return;
        }

        fetch('<?php echo admin_url('receipe_managements/save_recipe'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ 
                product_id: productId, 
                components: filteredComponents, 
                day: dayValue 
            })
        })
        .then(res => res.text())
        .then(text => {
            try {
                const data = JSON.parse(text);
                if (data.success) {
                    alert('<?php echo _l('recipe_saved_successfully'); ?>');
                    window.location.href = '<?php echo admin_url('receipe_managements/recipe_management'); ?>';
                } else {
                    alert('<?php echo _l('server_error'); ?>: ' + data.message);
                }
            } catch (e) {
                alert('<?php echo _l('something_went_wrong'); ?>: Invalid JSON from server:\n' + text);
                console.error("Server response:", text);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('<?php echo _l('error_saving_recipe'); ?>');
        });
    });

    function showModal(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) modal.classList.add('show');
    }

    function hideModal(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) modal.classList.remove('show');
    }

    // Show modal if "Add New Product" is selected
    document.getElementById('productSelect').addEventListener('change', function() {
        if (this.value === '__add_new__') {
            showModal('addProductModal');
            document.getElementById('newProductName').value = '';
            document.getElementById('newProductNameError').textContent = '';
        }
    });

    // Show modal if "Create New Day Shift" is selected
    document.getElementById('daySelect').addEventListener('change', function() {
        if (this.value === '__add_new_day__') {
            showModal('addDayShiftModal');
            document.getElementById('newDayShiftName').value = '';
            document.getElementById('newDayShiftNameError').textContent = '';
        }
    });

    // Close modal on close button or clicking outside modal-content
    (function() {
        const modal = document.getElementById('addProductModal');
        const closeBtn = document.getElementById('closeAddProductModal');
        if (closeBtn && modal) {
            closeBtn.addEventListener('click', function() {
                hideModal('addProductModal');
            });
        }
        // Optional: close modal when clicking outside modal-content
        if (modal) {
            modal.addEventListener('click', function(e) {
                if (e.target === modal) hideModal('addProductModal');
            });
        }
    })();

    (function() {
        const modal = document.getElementById('addDayShiftModal');
        const closeBtn = document.getElementById('closeAddDayShiftModal');
        if (closeBtn && modal) {
            closeBtn.addEventListener('click', function() {
                hideModal('addDayShiftModal');
            });
        }
        if (modal) {
            modal.addEventListener('click', function(e) {
                if (e.target === modal) hideModal('addDayShiftModal');
            });
        }
    })();

    // Save new product
    document.getElementById('addProductForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const name = document.getElementById('newProductName').value.trim();
        const errorDiv = document.getElementById('newProductNameError');
        errorDiv.textContent = '';
        if (!name) {
            errorDiv.textContent = '<?php echo _l('please_enter_product_name'); ?>';
            return;
        }
        fetch('<?php echo admin_url('receipe_managements/add_product'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ name })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success && data.product_id) {
                hideModal('addProductModal');
                loadProducts(data.product_id);
            } else {
                errorDiv.textContent = data.message || '<?php echo _l('server_error'); ?>';
            }
        })
        .catch(() => {
            errorDiv.textContent = '<?php echo _l('server_error'); ?>';
        });
    });

    // Save new day shift
    document.getElementById('addDayShiftForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const name = document.getElementById('newDayShiftName').value.trim();
        const errorDiv = document.getElementById('newDayShiftNameError');
        errorDiv.textContent = '';
        if (!name) {
            errorDiv.textContent = '<?php echo _l('please_enter_day_shift_name'); ?>';
            return;
        }
        fetch('<?php echo admin_url('receipe_managements/add_day_shift'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ name })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success && data.day_shift) {
                hideModal('addDayShiftModal');
                loadDayTypes(data.day_shift); // reload and select new
            } else {
                errorDiv.textContent = data.message || '<?php echo _l('server_error'); ?>';
            }
        })
        .catch(() => {
            errorDiv.textContent = '<?php echo _l('server_error'); ?>';
        });
    });

    let lastProductValue = '';

    const productSelect = document.getElementById('productSelect');

    // Track the last valid selection
    productSelect.addEventListener('focus', function() {
        lastProductValue = this.value;
    });

    // Open modal on mousedown for "Add New Product" and prevent selection
    productSelect.addEventListener('mousedown', function(e) {
        const option = e.target;
        if (option.tagName === 'OPTION' && option.value === '__add_new__') {
            e.preventDefault();
            showModal('addProductModal');
            document.getElementById('newProductName').value = '';
            document.getElementById('newProductNameError').textContent = '';
        }
    });

    // Prevent selecting "Add New Product" in change event
    productSelect.addEventListener('change', function() {
        if (this.value === '__add_new__') {
            this.value = lastProductValue || '';
        } else {
            lastProductValue = this.value;
        }
    });

    let lastDayShiftValue = '';
    const daySelect = document.getElementById('daySelect');

    // Track the last valid selection for day shift
    daySelect.addEventListener('focus', function() {
        lastDayShiftValue = this.value;
    });

    // Open modal on mousedown for "Create New Day Shift" and prevent selection
    daySelect.addEventListener('mousedown', function(e) {
        const option = e.target;
        if (option.tagName === 'OPTION' && option.value === '__add_new_day__') {
            e.preventDefault();
            showModal('addDayShiftModal');
            document.getElementById('newDayShiftName').value = '';
            document.getElementById('newDayShiftNameError').textContent = '';
        }
    });

    // Prevent selecting "Create New Day Shift" in change event
    daySelect.addEventListener('change', function() {
        if (this.value === '__add_new_day__') {
            this.value = lastDayShiftValue || '';
        } else {
            lastDayShiftValue = this.value;
        }
    });
});
</script>

<?php init_tail(); ?>