<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        
                    <div class="page-heading-summary">
                        <span class="page-heading-icon">
                            <i class="fa fa-cutlery"></i>
                        </span>
                        <h3 class="page-title"><?php echo _l('recipe_management'); ?></h3>
                    </div>

                        <div class="controls">
                            <div class="form-group-custom">
                                <label for="productSelect" class="form-label-custom"><?php echo _l('select_product'); ?></label>
                                <select id="productSelect" required class="form-control">
                                </select>
                                <div class="error-message" id="productSelectError"></div>
                            </div>
                            <div class="form-group-custom">
                                <label for="quantityInput" class="form-label-custom"><?php echo _l('number_of_unit'); ?></label>
                                <input type="number" id="quantityInput" value="" class="form-control" placeholder="<?php echo _l('quantity'); ?>" required>
                                <div class="error-message" id="quantityInputError"></div>
                            </div>
                            <div class="form-group-custom">
                                <label for="dayTypeFilter" class="form-label-custom"><?php echo _l('group'); ?></label>
                                <select id="dayTypeFilter" required class="form-control">
                                    <option value=""> <?php echo _l('select_group'); ?></option>
                                </select>
                                <div class="error-message" id="dayTypeFilterError"></div>
                            </div>
                            <div>
                                <button id="submitBtn" class="btn btn-primary" type="button"><?php echo _l('Submit'); ?></button>
                            </div>
                        </div>
                        
                        <div class="main-flex" style="display: flex; gap: 20px;">
                            <div id="componentGroups" class="main-content" style="flex: 2;"></div>
                            <div id="summaryContainer" style="flex: 1;"></div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="loaderOverlay" class="loader-overlay">
    <div class="loader-spinner"></div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    let lastComponentsByDay = {};
    let selectedDayType = '';

    // Load products on page load
    loadProducts();
    loadGroups();

    function loadProducts() {
        fetch('<?php echo admin_url('receipe_managements/get_recipe_products'); ?>')
            .then(response => response.json())
            .then(data => {
                const productSelect = document.getElementById('productSelect');
                productSelect.innerHTML = '<option value=""> <?php echo _l('select_product'); ?> </option>';
                
                data.forEach(product => {
                    const option = document.createElement('option');
                    option.value = product.id;
                    option.textContent = product.name;
                    productSelect.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error loading products:', error);
            });
    }

    function loadGroups() {
        fetch('<?php echo admin_url('receipe_managements/get_recipe_groups'); ?>')
            .then(response => response.json())
            .then(data => {
                const dayTypeFilter = document.getElementById('dayTypeFilter');
                dayTypeFilter.innerHTML = '<option value=""> <?php echo _l('select_group'); ?> </option>';
                data.forEach(group => {
                    const option = document.createElement('option');
                    option.value = group.id;
                    option.textContent = group.day_shift;
                    dayTypeFilter.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error loading groups:', error);
            });
    }

    function showLoader() {
        document.getElementById('loaderOverlay').style.display = 'flex';
    }

    function hideLoader() {
        document.getElementById('loaderOverlay').style.display = 'none';
    }

    document.getElementById('submitBtn').addEventListener('click', function() {
        const productId = document.getElementById('productSelect').value;
        const qty = document.getElementById('quantityInput').value;
        const dayType = document.getElementById('dayTypeFilter').value;

        // Validate all fields
        let hasError = false;

        // Reset previous error styles and messages
        document.getElementById('productSelect').style.borderColor = '#ccc';
        document.getElementById('quantityInput').style.borderColor = '#ccc';
        document.getElementById('dayTypeFilter').style.borderColor = '#ccc';
        document.getElementById('productSelectError').textContent = '';
        document.getElementById('quantityInputError').textContent = '';
        document.getElementById('dayTypeFilterError').textContent = '';

        const qtyValue = document.getElementById('quantityInput').value;
        if (qtyValue === '') {
            document.getElementById('quantityInput').style.borderColor = 'red';
            document.getElementById('quantityInputError').textContent = '<?php echo _l('please_enter_quantity'); ?>';
            hasError = true;
        } else if (isNaN(qtyValue) || Number(qtyValue) <= 0) {
            document.getElementById('quantityInput').style.borderColor = 'red';
            document.getElementById('quantityInputError').textContent = '<?php echo _l('please_enter_valid_quantity'); ?>';
            hasError = true;
        }

        if (!productId) {
            document.getElementById('productSelect').style.borderColor = 'red';
            document.getElementById('productSelectError').textContent = '<?php echo _l('please_select_product'); ?>';
            hasError = true;
        }
        if (!dayType) {
            document.getElementById('dayTypeFilter').style.borderColor = 'red';
            document.getElementById('dayTypeFilterError').textContent = '<?php echo _l('please_select_group'); ?>';
            hasError = true;
        }
        if (hasError) return;

        showLoader(); // Show loader before fetch

        fetch(`<?php echo admin_url('receipe_managements/get_product_component'); ?>?product_id=${productId}&qty=${qty}&dayType=${dayType}`)
            .then(res => res.json())
            .then(data => {
                setTimeout(function() {
                    hideLoader(); // Hide loader after 2 seconds
                    if (data.success && data.components_by_day) {
                        const dayTypes = Object.keys(data.components_by_day);
                        var selectedDayType = dayTypes[0];
                        lastComponentsByDay = data.components_by_day;
                        renderAllDayTypes(lastComponentsByDay, selectedDayType, qty);
                    } else {
                        document.getElementById('componentGroups').innerHTML = '<div class="no-data">No components found.</div>';
                        document.getElementById('summaryContainer').innerHTML = '';
                    }
                }, 100); // 2000 milliseconds = 2 seconds
            })
            .catch(error => {
                setTimeout(function() {
                    hideLoader(); // Hide loader after 2 seconds even on error
                    console.error('Error fetching product data:', error);
                    document.getElementById('componentGroups').innerHTML = '<div class="no-data">Error loading data.</div>';
                    document.getElementById('summaryContainer').innerHTML = '';
                }, 2000);
            });
    });

    [
        { id: 'productSelect', event: 'change', errorId: 'productSelectError' },
        { id: 'quantityInput', event: 'input', errorId: 'quantityInputError' },
        { id: 'dayTypeFilter', event: 'change', errorId: 'dayTypeFilterError' }
    ].forEach(cfg => {
        const el = document.getElementById(cfg.id);
        const err = document.getElementById(cfg.errorId);
        if (el && err) {
            el.addEventListener(cfg.event, function() {
                this.style.borderColor = '#ccc';
                err.textContent = '';
            });
        }
    });

    function renderGroupTable(group, groupLabel, qty = 1) {
        let total = 0;
        let html = `<div class="group-section">
        <div class="group-title">${groupLabel}</div>
        <table>
        <thead>
            <tr>
            <th><?php echo _l('component'); ?></th>
            <th><?php echo _l('quantity'); ?></th>
            </tr>
        </thead>
        <tbody>
        `;

        if (!group || group.length === 0) {
            html += `<tr><td colspan="2" class="no-data">No components</td></tr>`;
        } else {
            html += group.map(comp => {
                const baseQty = parseFloat(comp.quantity);
                const actualQty = baseQty * qty;
                let unit = comp.unit.toLowerCase();
                let displayQty = Math.round(actualQty);
                let displayUnit = (unit === "gram" || unit === "g") ? "gm" : comp.unit;

                // Sum rounded value
                if (!isNaN(displayQty)) total += displayQty;

                return `
            <tr>
            <td>${comp.name || comp.component_id}</td>
            <td>${displayQty} ${displayUnit}</td>
            </tr>
            `;
            }).join('');
        }

        // Determine total unit based on first component's unit
        let totalUnit = group.length > 0 ? group[0].unit.toLowerCase() : '';
        let displayTotalUnit = (totalUnit === "gram" || totalUnit === "g") ? "gm" : totalUnit;

        // Display total in appropriate unit as a summary row
        let totalQty = total.toFixed(2);

        if (group && group.length > 0) {
            html += `
        <tr style="font-weight:bold; color:#2b6cb0;">
        <td><?php echo _l('total'); ?> ${groupLabel} <?php echo _l('quantity'); ?></td>
        <td>${totalQty} ${displayTotalUnit}</td>
        </tr>
        `;
        }

        html += `</tbody></table></div>`;
        return { html, total, unit: displayTotalUnit };
    }

    function renderAllDayTypes(components_by_day, filterDayType, qty = 1) {
        const container = document.getElementById('componentGroups');
        const summary = document.getElementById('summaryContainer');
        container.innerHTML = '';
        summary.innerHTML = '';
        let summaryTotals = {
            Levain: 0,
            Autolyse: 0,
            'Seed Mix': 0
        };
        let summaryUnits = {
            Levain: '',
            Autolyse: '',
            'Seed Mix': ''
        };

        Object.entries(components_by_day).forEach(([dayType, groups]) => {
            if (filterDayType !== dayType) return;

            const levainResult = renderGroupTable(groups.levain, '<?php echo _l('levain'); ?>', qty);
            const autolyseResult = renderGroupTable(groups.autolyse, '<?php echo _l('autolyse'); ?>', qty);
            const seedMixResult = renderGroupTable(groups.seed_mix, '<?php echo _l('seed_mix'); ?>', qty);

            summaryTotals.Levain += levainResult.total;
            summaryTotals.Autolyse += autolyseResult.total;
            summaryTotals['Seed Mix'] += seedMixResult.total;

            summaryUnits.Levain = levainResult.unit || summaryUnits.Levain;
            summaryUnits.Autolyse = autolyseResult.unit || summaryUnits.Autolyse;
            summaryUnits['Seed Mix'] = seedMixResult.unit || summaryUnits['Seed Mix'];

            container.innerHTML += `
              <div class="group-title"><?php echo _l('day_type'); ?>: ${dayType}</div>
              ${levainResult.html}
              ${autolyseResult.html}
              ${seedMixResult.html}
            `;
        });

        // Render summary at the bottom (in right panel)
        const qtyLabel = qty == 1 ? "<?php echo _l('for_loaf'); ?>" : `<?php echo sprintf(_l('for_loaves'), '${qty}'); ?>`;
        
        function formatQty(val, unit) {
            let displayVal = Number.isInteger(val) ? val : val.toFixed(2);
            let displayUnit = (unit === "gram" || unit === "g") ? "gm" : unit;
            return `${displayVal} ${displayUnit}`;
        }

        summary.innerHTML = `
  <div class="summary-section">
    <h3><?php echo _l('total'); ?></h3>
    <table>
      <thead>
        <tr>
          <th><?php echo _l('component'); ?></th>
          <th>${qtyLabel}</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><?php echo _l('levain'); ?></td>
          <td>${formatQty(summaryTotals.Levain, summaryUnits.Levain)}</td>
        </tr>
        <tr>
          <td><?php echo _l('autolyse'); ?></td>
          <td>${formatQty(summaryTotals.Autolyse, summaryUnits.Autolyse)}</td>
        </tr>
        <tr>
          <td><?php echo _l('seed_mix'); ?></td>
          <td>${formatQty(summaryTotals['Seed Mix'], summaryUnits['Seed Mix'])}</td>
        </tr>
        <tr>
          <td style="font-weight:bold; color:#2b6cb0;">TOTAL</td>
          <td style="font-weight:bold; color:#2b6cb0;">${formatQty(
                summaryTotals.Autolyse +
                summaryTotals['Seed Mix'] +
                summaryTotals.Levain,
                "g"
            )}</td>
        </tr>
      </tbody>
    </table>
  </div>
    `;

        // Calculate total for each unique component across all groups
        let componentTotals = {};
        let componentUnits = {};

        const groups = components_by_day[filterDayType];
        ['levain', 'autolyse', 'seed_mix'].forEach(groupKey => {
            const group = groups[groupKey];
            if (group && group.length > 0) {
                group.forEach(comp => {
                    const name = comp.name || comp.component_id;
                    const unit = comp.unit;
                    let actualQty = parseFloat(comp.quantity) * qty;
                    let displayQty = Math.round(actualQty);

                    // Convert grams to kg if more than 1000g
                    if ((unit.toLowerCase() === "gram" || unit.toLowerCase() === "g") && actualQty >= 1000) {
                        displayQty = Math.round(actualQty / 1000);
                    }

                    if (!componentTotals[name]) {
                        componentTotals[name] = 0;
                        componentUnits[name] = unit;
                    }
                    componentTotals[name] += displayQty;
                });
            }
        });

        // Build the component summary table
        let componentSummaryTable = `
<div class="summary-section">
  <h3><?php echo _l('total_components'); ?></h3>
  <table>
    <thead>
      <tr>
        <th><?php echo _l('component'); ?></th>
        <th>${qtyLabel}</th>
      </tr>
    </thead>
    <tbody>
`;

        let grandTotal = 0;
        Object.entries(componentTotals).forEach(([name, total]) => {
            const unit = componentUnits[name];
            componentSummaryTable += `
      <tr>
        <td>${name}</td>
        <td>${formatQty(total, unit)}</td>
      </tr>
    `;
            // For grand total, sum only grams (convert kg to g if needed)
            if (unit === "g" || unit === "gram" || unit === "grams") {
                grandTotal += total;
            } else if (unit === "kg") {
                grandTotal += total * 1000;
            }
        });
        componentSummaryTable += `
      <tr>
        <td style="font-weight:bold; color:#2b6cb0;"><?php echo _l('grand_total'); ?></td>
        <td style="font-weight:bold; color:#2b6cb0;">${formatQty(grandTotal, "g")}</td>
      </tr>
    </tbody>
  </table>
</div>
`;

        // Append to summary
        summary.innerHTML += componentSummaryTable;
    }
});
</script>

<?php init_tail(); ?>
