<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Website E-commerce Configuration
 * 
 * Configuration settings for the website module's e-commerce functionality
 * and integration with omni_sales module.
 * 
 * @package Website Module
 * @subpackage Config
 */

// E-commerce Service Configuration
$config['website_ecommerce'] = [
    
    // Service Integration Settings
    'integration' => [
        'use_omni_sales_backend' => true,
        'sales_channel_id' => 2, // Portal channel ID in omni_sales
        'channel_name' => 'portal',
        'warehouse_id' => 0, // Default warehouse (0 = all warehouses)
    ],
    
    // Product Display Settings
    'products' => [
        'per_page' => 12, // Default products per page
        'per_row' => 3, // Default products per row
        'enable_stock_check' => true,
        'show_out_of_stock' => true,
        'enable_wishlist' => false, // Future feature
        'enable_comparison' => false, // Future feature
        'image_placeholder' => 'assets/images/no-image-available.png',
    ],
    
    // Cart Settings
    'cart' => [
        'session_timeout' => 3600, // Cart session timeout in seconds (1 hour)
        'max_quantity_per_item' => 100,
        'auto_remove_out_of_stock' => true,
        'guest_cart_enabled' => true,
    ],
    
    // Order Settings
    'orders' => [
        'require_login' => true, // Require login to place orders
        'order_number_prefix' => 'WEB-',
        'default_status' => 1, // Default order status
        'email_notifications' => true,
    ],
    
    // Pricing Settings
    'pricing' => [
        'show_discounts' => true,
        'show_percentage_discount' => true,
        'currency_format' => 'symbol_before', // symbol_before, symbol_after, code_before, code_after
        'decimal_places' => 2,
    ],
    
    // API Settings
    'api' => [
        'enable_cors' => true,
        'rate_limiting' => false, // Future feature
        'cache_duration' => 300, // Cache API responses for 5 minutes
        'enable_debug' => false, // Enable detailed error messages
    ],
    
    // Search Settings
    'search' => [
        'min_query_length' => 2,
        'max_suggestions' => 10,
        'search_fields' => ['name', 'description', 'sku'], // Fields to search in
    ],
    
    // UI/UX Settings
    'ui' => [
        'enable_ajax_cart' => true,
        'show_loading_animations' => true,
        'notification_type' => 'toastr', // toastr, alert_float, native
        'enable_product_zoom' => false, // Future feature
        'enable_quick_view' => false, // Future feature
    ],
    
    // SEO Settings
    'seo' => [
        'enable_friendly_urls' => true,
        'meta_title_suffix' => ' - Your Store Name',
        'enable_breadcrumbs' => true,
        'enable_structured_data' => false, // Future feature
    ],
    
    // Performance Settings
    'performance' => [
        'enable_caching' => true,
        'cache_products' => 300, // Cache products for 5 minutes
        'cache_categories' => 3600, // Cache categories for 1 hour
        'lazy_load_images' => false, // Future feature
    ],
    
    // Security Settings
    'security' => [
        'enable_csrf_protection' => true,
        'validate_user_permissions' => true,
        'log_api_requests' => false, // Log API requests for debugging
        'sanitize_inputs' => true,
    ]
];

// Feature Flags
$config['website_features'] = [
    'advanced_search' => false,
    'product_reviews' => false,
    'wishlist' => false,
    'product_comparison' => false,
    'multi_currency' => false,
    'inventory_alerts' => true,
    'promotional_banners' => false,
    'related_products' => true,
    'recently_viewed' => false,
    'social_sharing' => false,
];

// Error Messages
$config['website_error_messages'] = [
    'product_not_found' => 'Product not found or unavailable',
    'insufficient_stock' => 'Insufficient stock available',
    'cart_empty' => 'Your cart is empty',
    'login_required' => 'Please log in to continue',
    'invalid_quantity' => 'Invalid quantity specified',
    'api_error' => 'An error occurred. Please try again later',
    'network_error' => 'Network error. Please check your connection',
    'server_error' => 'Server error. Please contact support if the problem persists',
];

// Success Messages
$config['website_success_messages'] = [
    'added_to_cart' => 'Product added to cart successfully',
    'cart_updated' => 'Cart updated successfully',
    'item_removed' => 'Item removed from cart',
    'order_placed' => 'Order placed successfully',
    'profile_updated' => 'Profile updated successfully',
];

// Default Values
$config['website_defaults'] = [
    'products_per_page' => 12,
    'products_per_row' => 3,
    'search_results_per_page' => 20,
    'related_products_count' => 6,
    'recently_viewed_count' => 8,
    'cart_session_name' => 'website_cart',
];