<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Website module installation
 */
function website_module_install()
{
    $CI = &get_instance();
    
    // Create database tables
    $CI->load->dbforge();
    
    // Website pages table
    $CI->dbforge->add_field([
        'id' => [
            'type' => 'INT',
            'constraint' => 11,
            'unsigned' => TRUE,
            'auto_increment' => TRUE
        ],
        'title' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'slug' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'content' => [
            'type' => 'LONGTEXT',
            'null' => TRUE
        ],
        'excerpt' => [
            'type' => 'TEXT',
            'null' => TRUE
        ],
        'meta_title' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => TRUE
        ],
        'meta_description' => [
            'type' => 'TEXT',
            'null' => TRUE
        ],
        'meta_keywords' => [
            'type' => 'TEXT',
            'null' => TRUE
        ],
        'template_id' => [
            'type' => 'INT',
            'constraint' => 11,
            'null' => TRUE
        ],
        'status' => [
            'type' => 'ENUM',
            'constraint' => ['draft', 'published', 'archived'],
            'default' => 'draft'
        ],
        'featured_image' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => TRUE
        ],
        'sort_order' => [
            'type' => 'INT',
            'constraint' => 11,
            'default' => 0
        ],
        'created_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'updated_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'created_by' => [
            'type' => 'INT',
            'constraint' => 11,
            'null' => TRUE
        ]
    ]);
    
    $CI->dbforge->add_key('id', TRUE);
    $CI->dbforge->add_key('slug');
    $CI->dbforge->add_key('status');
    $CI->dbforge->create_table('website_pages', TRUE);
    
    // Website templates table
    $CI->dbforge->add_field([
        'id' => [
            'type' => 'INT',
            'constraint' => 11,
            'unsigned' => TRUE,
            'auto_increment' => TRUE
        ],
        'name' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'description' => [
            'type' => 'TEXT',
            'null' => TRUE
        ],
        'template_file' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'preview_image' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => TRUE
        ],
        'is_active' => [
            'type' => 'TINYINT',
            'constraint' => 1,
            'default' => 1
        ],
        'created_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'updated_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ]
    ]);
    
    $CI->dbforge->add_key('id', TRUE);
    $CI->dbforge->create_table('website_templates', TRUE);
    
    // Website media table
    $CI->dbforge->add_field([
        'id' => [
            'type' => 'INT',
            'constraint' => 11,
            'unsigned' => TRUE,
            'auto_increment' => TRUE
        ],
        'filename' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'original_name' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'file_path' => [
            'type' => 'VARCHAR',
            'constraint' => 500,
            'null' => FALSE
        ],
        'file_type' => [
            'type' => 'VARCHAR',
            'constraint' => 100,
            'null' => FALSE
        ],
        'file_size' => [
            'type' => 'BIGINT',
            'constraint' => 20,
            'null' => TRUE
        ],
        'alt_text' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => TRUE
        ],
        'caption' => [
            'type' => 'TEXT',
            'null' => TRUE
        ],
        'created_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'created_by' => [
            'type' => 'INT',
            'constraint' => 11,
            'null' => TRUE
        ]
    ]);
    
    $CI->dbforge->add_key('id', TRUE);
    $CI->dbforge->add_key('file_type');
    $CI->dbforge->create_table('website_media', TRUE);
    
    // Website navigation table
    $CI->dbforge->add_field([
        'id' => [
            'type' => 'INT',
            'constraint' => 11,
            'unsigned' => TRUE,
            'auto_increment' => TRUE
        ],
        'title' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'url' => [
            'type' => 'VARCHAR',
            'constraint' => 500,
            'null' => FALSE
        ],
        'page_id' => [
            'type' => 'INT',
            'constraint' => 11,
            'null' => TRUE
        ],
        'parent_id' => [
            'type' => 'INT',
            'constraint' => 11,
            'null' => TRUE
        ],
        'sort_order' => [
            'type' => 'INT',
            'constraint' => 11,
            'default' => 0
        ],
        'is_active' => [
            'type' => 'TINYINT',
            'constraint' => 1,
            'default' => 1
        ],
        'target' => [
            'type' => 'ENUM',
            'constraint' => ['_self', '_blank'],
            'default' => '_self'
        ],
        'created_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'updated_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ]
    ]);
    
    $CI->dbforge->add_key('id', TRUE);
    $CI->dbforge->add_key('parent_id');
    $CI->dbforge->add_key('sort_order');
    $CI->dbforge->create_table('website_navigation', TRUE);
    
    // Website settings table
    $CI->dbforge->add_field([
        'id' => [
            'type' => 'INT',
            'constraint' => 11,
            'unsigned' => TRUE,
            'auto_increment' => TRUE
        ],
        'setting_key' => [
            'type' => 'VARCHAR',
            'constraint' => 255,
            'null' => FALSE
        ],
        'setting_value' => [
            'type' => 'LONGTEXT',
            'null' => TRUE
        ],
        'setting_type' => [
            'type' => 'ENUM',
            'constraint' => ['text', 'textarea', 'select', 'checkbox', 'file'],
            'default' => 'text'
        ],
        'created_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ],
        'updated_at' => [
            'type' => 'DATETIME',
            'null' => TRUE
        ]
    ]);
    
    $CI->dbforge->add_key('id', TRUE);
    $CI->dbforge->add_key('setting_key');
    $CI->dbforge->create_table('website_settings', TRUE);
    
    // Insert default settings
    $default_settings = [
        ['setting_key' => 'site_title', 'setting_value' => 'My Website', 'setting_type' => 'text'],
        ['setting_key' => 'site_description', 'setting_value' => 'Welcome to my website', 'setting_type' => 'textarea'],
        ['setting_key' => 'site_logo', 'setting_value' => '', 'setting_type' => 'file'],
        ['setting_key' => 'default_template', 'setting_value' => '1', 'setting_type' => 'select'],
        ['setting_key' => 'posts_per_page', 'setting_value' => '10', 'setting_type' => 'text'],
        ['setting_key' => 'enable_comments', 'setting_value' => '1', 'setting_type' => 'checkbox'],
    ];
    
    foreach ($default_settings as $setting) {
        $CI->db->insert('website_settings', $setting);
    }
    
    // Insert default template
    $default_template = [
        'name' => 'Default Template',
        'description' => 'Default website template',
        'template_file' => 'default.php',
        'is_active' => 1,
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    $CI->db->insert('website_templates', $default_template);
    
    // Insert sample pages
    $sample_pages = [
        [
            'title' => 'Home',
            'slug' => 'home',
            'content' => '<h1>Welcome to Our Website</h1><p>This is the homepage content.</p>',
            'excerpt' => 'Welcome to our website',
            'meta_title' => 'Home - My Website',
            'meta_description' => 'Welcome to our website',
            'status' => 'published',
            'sort_order' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' => 1
        ],
        [
            'title' => 'About Us',
            'slug' => 'about',
            'content' => '<h1>About Us</h1><p>Learn more about our company.</p>',
            'excerpt' => 'About our company',
            'meta_title' => 'About Us - My Website',
            'meta_description' => 'Learn more about our company',
            'status' => 'published',
            'sort_order' => 2,
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' => 1
        ],
        [
            'title' => 'Contact',
            'slug' => 'contact',
            'content' => '<h1>Contact Us</h1><p>Get in touch with us.</p>',
            'excerpt' => 'Contact information',
            'meta_title' => 'Contact Us - My Website',
            'meta_description' => 'Get in touch with us',
            'status' => 'published',
            'sort_order' => 3,
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' => 1
        ]
    ];
    
    foreach ($sample_pages as $page) {
        $CI->db->insert('website_pages', $page);
    }
    
    // Insert sample navigation
    $sample_navigation = [
        [
            'title' => 'Home',
            'url' => '/',
            'page_id' => 1,
            'sort_order' => 1,
            'is_active' => 1,
            'created_at' => date('Y-m-d H:i:s')
        ],
        [
            'title' => 'About',
            'url' => '/about',
            'page_id' => 2,
            'sort_order' => 2,
            'is_active' => 1,
            'created_at' => date('Y-m-d H:i:s')
        ],
        [
            'title' => 'Contact',
            'url' => '/contact',
            'page_id' => 3,
            'sort_order' => 3,
            'is_active' => 1,
            'created_at' => date('Y-m-d H:i:s')
        ]
    ];
    
    foreach ($sample_navigation as $nav) {
        $CI->db->insert('website_navigation', $nav);
    }
    
    return true;
}
