<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin"><?php echo _l('add_page'); ?></h4>
                        <hr class="hr-panel-heading" />
                        
                        <?php echo form_open(admin_url('website/add_page')); ?>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="title" class="control-label"><?php echo _l('page_title'); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="title" id="title" value="<?php echo set_value('title'); ?>" required>
                                    <?php echo form_error('title'); ?>
                                </div>
                                
                                <div class="form-group">
                                    <label for="slug" class="control-label"><?php echo _l('page_slug'); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="slug" id="slug" value="<?php echo set_value('slug'); ?>" required>
                                    <small class="help-block"><?php echo _l('slug_help_text'); ?></small>
                                    <?php echo form_error('slug'); ?>
                                </div>
                                
                                <div class="form-group">
                                    <label for="content" class="control-label"><?php echo _l('page_content'); ?> <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="content" id="content" rows="15" required><?php echo set_value('content'); ?></textarea>
                                    <?php echo form_error('content'); ?>
                                </div>
                                
                                <div class="form-group">
                                    <label for="excerpt" class="control-label"><?php echo _l('page_excerpt'); ?></label>
                                    <textarea class="form-control" name="excerpt" id="excerpt" rows="3"><?php echo set_value('excerpt'); ?></textarea>
                                    <small class="help-block"><?php echo _l('excerpt_help_text'); ?></small>
                                    <?php echo form_error('excerpt'); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><?php echo _l('page_settings'); ?></h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <label for="status" class="control-label"><?php echo _l('page_status'); ?></label>
                                            <select class="form-control" name="status" id="status">
                                                <option value="draft" <?php echo set_select('status', 'draft', true); ?>><?php echo _l('page_status_draft'); ?></option>
                                                <option value="published" <?php echo set_select('status', 'published'); ?>><?php echo _l('page_status_published'); ?></option>
                                                <option value="archived" <?php echo set_select('status', 'archived'); ?>><?php echo _l('page_status_archived'); ?></option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="template_id" class="control-label"><?php echo _l('template'); ?></label>
                                            <select class="form-control" name="template_id" id="template_id">
                                                <option value=""><?php echo _l('default_template'); ?></option>
                                                <?php foreach ($templates as $template): ?>
                                                <option value="<?php echo $template->id; ?>" <?php echo set_select('template_id', $template->id); ?>>
                                                    <?php echo $template->name; ?>
                                                </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="sort_order" class="control-label"><?php echo _l('sort_order'); ?></label>
                                            <input type="number" class="form-control" name="sort_order" id="sort_order" value="<?php echo set_value('sort_order', 0); ?>" min="0">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><?php echo _l('seo_settings'); ?></h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <label for="meta_title" class="control-label"><?php echo _l('meta_title'); ?></label>
                                            <input type="text" class="form-control" name="meta_title" id="meta_title" value="<?php echo set_value('meta_title'); ?>">
                                            <small class="help-block"><?php echo _l('meta_title_help_text'); ?></small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="meta_description" class="control-label"><?php echo _l('meta_description'); ?></label>
                                            <textarea class="form-control" name="meta_description" id="meta_description" rows="3"><?php echo set_value('meta_description'); ?></textarea>
                                            <small class="help-block"><?php echo _l('meta_description_help_text'); ?></small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="meta_keywords" class="control-label"><?php echo _l('meta_keywords'); ?></label>
                                            <input type="text" class="form-control" name="meta_keywords" id="meta_keywords" value="<?php echo set_value('meta_keywords'); ?>">
                                            <small class="help-block"><?php echo _l('meta_keywords_help_text'); ?></small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> <?php echo _l('save'); ?>
                                </button>
                                <a href="<?php echo admin_url('website/pages'); ?>" class="btn btn-default">
                                    <i class="fa fa-times"></i> <?php echo _l('cancel'); ?>
                                </a>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Auto-generate slug from title
    $('#title').on('keyup', function() {
        var title = $(this).val();
        var slug = title.toLowerCase()
            .replace(/[^a-z0-9 -]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .trim('-');
        $('#slug').val(slug);
    });
    
    // Initialize rich text editor
    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: '#content',
            height: 400,
            menubar: false,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table paste code help wordcount'
            ],
            toolbar: 'undo redo | formatselect | bold italic backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help'
        });
    }
});
</script>

<?php init_tail(); ?>
