<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="no-margin"><?php echo _l('pages'); ?></h4>
                            </div>
                            <div class="col-md-6">
                                <a href="<?php echo admin_url('website/add_page'); ?>" class="btn btn-primary pull-right">
                                    <i class="fa fa-plus"></i> <?php echo _l('add_page'); ?>
                                </a>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />
                        
                        <div class="table-responsive">
                            <table class="table dt-table table-pages" data-order-col="3" data-order-type="desc">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('title'); ?></th>
                                        <th><?php echo _l('slug'); ?></th>
                                        <th><?php echo _l('status'); ?></th>
                                        <th><?php echo _l('created_at'); ?></th>
                                        <th><?php echo _l('actions'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($pages as $page): ?>
                                    <tr>
                                        <td>
                                            <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>">
                                                <?php echo $page->title; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <code><?php echo $page->slug; ?></code>
                                        </td>
                                        <td>
                                            <span class="label label-<?php echo $page->status == 'published' ? 'success' : ($page->status == 'draft' ? 'warning' : 'default'); ?>">
                                                <?php echo ucfirst($page->status); ?>
                                            </span>
                                        </td>
                                        <td data-order="<?php echo $page->created_at; ?>">
                                            <?php echo _dt($page->created_at); ?>
                                        </td>
                                        <td>
                                            <div class="row-options">
                                                <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>" class="btn btn-default btn-xs">
                                                    <i class="fa fa-edit"></i> <?php echo _l('edit'); ?>
                                                </a>
                                                <a href="<?php echo admin_url('website/preview/' . $page->id); ?>" class="btn btn-info btn-xs" target="_blank">
                                                    <i class="fa fa-eye"></i> <?php echo _l('preview'); ?>
                                                </a>
                                                <a href="<?php echo admin_url('website/delete_page/' . $page->id); ?>" 
                                                   class="btn btn-danger btn-xs _delete" 
                                                   data-toggle="tooltip" 
                                                   title="<?php echo _l('delete'); ?>"
                                                   data-confirm="<?php echo _l('are_you_sure'); ?>">
                                                    <i class="fa fa-remove"></i> <?php echo _l('delete'); ?>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
