<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<!-- Component Templates (Hidden) -->
<div id="component-templates" style="display: none;">
    
    <!-- Hero Section Template -->
    <div class="page-section hero-section" data-component="hero">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h1>Your Amazing Headline</h1>
        <p>Compelling subheading that explains your value proposition</p>
        <a href="#" class="btn">Call to Action</a>
    </div>

    <!-- Content Section Template -->
    <div class="page-section content-section" data-component="content">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2>Section Title</h2>
        <p>Your content goes here. You can add multiple paragraphs, lists, and other content elements to create engaging sections for your website.</p>
    </div>

    <!-- Two Column Template -->
    <div class="page-section" data-component="two-column" style="padding: 40px 20px;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <div style="display: flex; gap: 30px; max-width: 1000px; margin: 0 auto;">
            <div style="flex: 1;">
                <h3>Left Column</h3>
                <p>Content for the left column goes here.</p>
            </div>
            <div style="flex: 1;">
                <h3>Right Column</h3>
                <p>Content for the right column goes here.</p>
            </div>
        </div>
    </div>

    <!-- Three Column Template -->
    <div class="page-section" data-component="three-column" style="padding: 40px 20px;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <div style="display: flex; gap: 20px; max-width: 1200px; margin: 0 auto;">
            <div style="flex: 1;">
                <h4>Column 1</h4>
                <p>Content for the first column.</p>
            </div>
            <div style="flex: 1;">
                <h4>Column 2</h4>
                <p>Content for the second column.</p>
            </div>
            <div style="flex: 1;">
                <h4>Column 3</h4>
                <p>Content for the third column.</p>
            </div>
        </div>
    </div>

    <!-- Button Component Template -->
    <div class="page-section" data-component="button" style="padding: 20px; text-align: center;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <a href="#" class="btn" style="background: #007bff; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; display: inline-block;">Button Text</a>
    </div>

    <!-- Image Component Template -->
    <div class="page-section" data-component="image" style="padding: 20px; text-align: center;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <img src="https://via.placeholder.com/600x300?text=Your+Image" alt="Placeholder Image" style="max-width: 100%; height: auto; border-radius: 8px;">
    </div>

    <!-- Text Block Template -->
    <div class="page-section" data-component="text" style="padding: 30px 20px;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h3>Text Block Title</h3>
        <p>This is a text block component. You can add any text content here, including headings, paragraphs, lists, and more.</p>
    </div>

    <!-- Spacer Template -->
    <div class="page-section" data-component="spacer" style="height: 50px; background: #f8f9fa; border: 1px dashed #dee2e6;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <div style="text-align: center; color: #6c757d; padding: 15px;">Spacer</div>
    </div>

    <!-- Product Grid Template -->
    <div class="page-section" data-component="product-grid" style="padding: 40px 20px; background: #f8f9fa;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2 style="text-align: center; margin-bottom: 40px;">Featured Products</h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 30px; max-width: 1200px; margin: 0 auto;">
            <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                <img src="https://via.placeholder.com/200x150?text=Product+1" alt="Product 1" style="width: 100%; height: 150px; object-fit: cover; border-radius: 4px; margin-bottom: 15px;">
                <h4>Product Name</h4>
                <p style="color: #666; margin: 10px 0;">Product description goes here.</p>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span style="font-size: 18px; font-weight: bold; color: #007bff;">$29.99</span>
                    <button style="background: #007bff; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer;">Add to Cart</button>
                </div>
            </div>
            <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                <img src="https://via.placeholder.com/200x150?text=Product+2" alt="Product 2" style="width: 100%; height: 150px; object-fit: cover; border-radius: 4px; margin-bottom: 15px;">
                <h4>Product Name</h4>
                <p style="color: #666; margin: 10px 0;">Product description goes here.</p>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span style="font-size: 18px; font-weight: bold; color: #007bff;">$39.99</span>
                    <button style="background: #007bff; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer;">Add to Cart</button>
                </div>
            </div>
            <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                <img src="https://via.placeholder.com/200x150?text=Product+3" alt="Product 3" style="width: 100%; height: 150px; object-fit: cover; border-radius: 4px; margin-bottom: 15px;">
                <h4>Product Name</h4>
                <p style="color: #666; margin: 10px 0;">Product description goes here.</p>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span style="font-size: 18px; font-weight: bold; color: #007bff;">$49.99</span>
                    <button style="background: #007bff; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer;">Add to Cart</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Pricing Table Template -->
    <div class="page-section" data-component="pricing-table" style="padding: 60px 20px; background: #f8f9fa;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2 style="text-align: center; margin-bottom: 50px;">Choose Your Plan</h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; max-width: 1000px; margin: 0 auto;">
            <div style="background: white; border-radius: 8px; padding: 40px 30px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                <h3>Basic</h3>
                <div style="font-size: 48px; font-weight: bold; color: #007bff; margin: 20px 0;">$19<span style="font-size: 18px;">/month</span></div>
                <ul style="list-style: none; padding: 0; margin: 30px 0;">
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Feature 1</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Feature 2</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Feature 3</li>
                </ul>
                <button style="background: #007bff; color: white; border: none; padding: 12px 30px; border-radius: 25px; cursor: pointer; width: 100%;">Get Started</button>
            </div>
            <div style="background: white; border-radius: 8px; padding: 40px 30px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border: 2px solid #007bff;">
                <h3>Pro</h3>
                <div style="font-size: 48px; font-weight: bold; color: #007bff; margin: 20px 0;">$49<span style="font-size: 18px;">/month</span></div>
                <ul style="list-style: none; padding: 0; margin: 30px 0;">
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ All Basic Features</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Advanced Feature 1</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Advanced Feature 2</li>
                </ul>
                <button style="background: #007bff; color: white; border: none; padding: 12px 30px; border-radius: 25px; cursor: pointer; width: 100%;">Get Started</button>
            </div>
            <div style="background: white; border-radius: 8px; padding: 40px 30px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                <h3>Enterprise</h3>
                <div style="font-size: 48px; font-weight: bold; color: #007bff; margin: 20px 0;">$99<span style="font-size: 18px;">/month</span></div>
                <ul style="list-style: none; padding: 0; margin: 30px 0;">
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ All Pro Features</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Enterprise Feature 1</li>
                    <li style="padding: 10px 0; border-bottom: 1px solid #eee;">✓ Enterprise Feature 2</li>
                </ul>
                <button style="background: #007bff; color: white; border: none; padding: 12px 30px; border-radius: 25px; cursor: pointer; width: 100%;">Get Started</button>
            </div>
        </div>
    </div>

    <!-- Testimonials Template -->
    <div class="page-section" data-component="testimonials" style="padding: 60px 20px; background: #f8f9fa;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2 style="text-align: center; margin-bottom: 50px;">What Our Customers Say</h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; max-width: 1000px; margin: 0 auto;">
            <div style="background: white; border-radius: 8px; padding: 30px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); text-align: center;">
                <div style="font-size: 48px; color: #007bff; margin-bottom: 20px;">"</div>
                <p style="font-style: italic; margin-bottom: 20px; color: #666;">This product has completely transformed our business. Highly recommended!</p>
                <div style="display: flex; align-items: center; justify-content: center;">
                    <img src="https://via.placeholder.com/50x50?text=JS" alt="Customer" style="width: 50px; height: 50px; border-radius: 50%; margin-right: 15px;">
                    <div>
                        <div style="font-weight: bold;">John Smith</div>
                        <div style="color: #666; font-size: 14px;">CEO, Company Inc.</div>
                    </div>
                </div>
            </div>
            <div style="background: white; border-radius: 8px; padding: 30px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); text-align: center;">
                <div style="font-size: 48px; color: #007bff; margin-bottom: 20px;">"</div>
                <p style="font-style: italic; margin-bottom: 20px; color: #666;">Excellent service and amazing results. We couldn't be happier!</p>
                <div style="display: flex; align-items: center; justify-content: center;">
                    <img src="https://via.placeholder.com/50x50?text=JD" alt="Customer" style="width: 50px; height: 50px; border-radius: 50%; margin-right: 15px;">
                    <div>
                        <div style="font-weight: bold;">Jane Doe</div>
                        <div style="color: #666; font-size: 14px;">Marketing Director</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Form Template -->
    <div class="page-section" data-component="contact-form" style="padding: 60px 20px; background: #f8f9fa;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <div style="max-width: 600px; margin: 0 auto; background: white; padding: 40px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
            <h2 style="text-align: center; margin-bottom: 30px;">Get In Touch</h2>
            <form>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Name</label>
                    <input type="text" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px;">
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Email</label>
                    <input type="email" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px;">
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Message</label>
                    <textarea style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px; height: 120px; resize: vertical;"></textarea>
                </div>
                <button type="submit" style="background: #007bff; color: white; border: none; padding: 12px 30px; border-radius: 4px; cursor: pointer; font-size: 16px; width: 100%;">Send Message</button>
            </form>
        </div>
    </div>

    <!-- Image Gallery Template -->
    <div class="page-section" data-component="gallery" style="padding: 40px 20px;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2 style="text-align: center; margin-bottom: 40px;">Image Gallery</h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; max-width: 1000px; margin: 0 auto;">
            <img src="https://via.placeholder.com/300x200?text=Image+1" alt="Gallery Image 1" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
            <img src="https://via.placeholder.com/300x200?text=Image+2" alt="Gallery Image 2" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
            <img src="https://via.placeholder.com/300x200?text=Image+3" alt="Gallery Image 3" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
            <img src="https://via.placeholder.com/300x200?text=Image+4" alt="Gallery Image 4" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
            <img src="https://via.placeholder.com/300x200?text=Image+5" alt="Gallery Image 5" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
            <img src="https://via.placeholder.com/300x200?text=Image+6" alt="Gallery Image 6" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;">
        </div>
    </div>

    <!-- Video Template -->
    <div class="page-section" data-component="video" style="padding: 40px 20px; text-align: center;">
        <div class="section-controls">
            <button class="section-btn" onclick="editSection(this)"><i class="fa fa-edit"></i></button>
            <button class="section-btn" onclick="duplicateSection(this)"><i class="fa fa-copy"></i></button>
            <button class="section-btn" onclick="deleteSection(this)"><i class="fa fa-trash"></i></button>
        </div>
        <h2 style="margin-bottom: 30px;">Watch Our Video</h2>
        <div style="max-width: 800px; margin: 0 auto; position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; border-radius: 8px;">
            <iframe src="https://www.youtube.com/embed/dQw4w9WgXcQ" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" frameborder="0" allowfullscreen></iframe>
        </div>
    </div>

</div>
