<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin"><?php echo _l('website'); ?> <?php echo _l('dashboard'); ?></h4>
                                <hr class="hr-panel-heading" />
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel_s">
                                    <div class="panel-body text-center">
                                        <h3 class="text-info"><?php echo $pages_count; ?></h3>
                                        <p class="text-muted"><?php echo _l('pages'); ?></p>
                                        <a href="<?php echo admin_url('website/pages'); ?>" class="btn btn-info btn-sm">
                                            <?php echo _l('manage'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel_s">
                                    <div class="panel-body text-center">
                                        <h3 class="text-success"><?php echo $templates_count; ?></h3>
                                        <p class="text-muted"><?php echo _l('templates'); ?></p>
                                        <a href="<?php echo admin_url('website/templates'); ?>" class="btn btn-success btn-sm">
                                            <?php echo _l('manage'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel_s">
                                    <div class="panel-body text-center">
                                        <h3 class="text-warning"><?php echo $media_count; ?></h3>
                                        <p class="text-muted"><?php echo _l('media_library'); ?></p>
                                        <a href="<?php echo admin_url('website/media'); ?>" class="btn btn-warning btn-sm">
                                            <?php echo _l('manage'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel_s">
                                    <div class="panel-body text-center">
                                        <h3 class="text-primary">0</h3>
                                        <p class="text-muted"><?php echo _l('navigation'); ?></p>
                                        <a href="<?php echo admin_url('website/navigation'); ?>" class="btn btn-primary btn-sm">
                                            <?php echo _l('manage'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if (!empty($recent_pages)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <h4><?php echo _l('recent_pages'); ?></h4>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th><?php echo _l('title'); ?></th>
                                                <th><?php echo _l('status'); ?></th>
                                                <th><?php echo _l('created_at'); ?></th>
                                                <th><?php echo _l('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($recent_pages as $page): ?>
                                                <tr>
                                                    <td>
                                                        <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>">
                                                            <?php echo $page->title; ?>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <span class="label label-<?php echo $page->status == 'published' ? 'success' : ($page->status == 'draft' ? 'warning' : 'default'); ?>">
                                                            <?php echo ucfirst($page->status); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo _dt($page->created_at); ?></td>
                                                    <td>
                                                        <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>" class="btn btn-default btn-sm">
                                                            <i class="fa fa-pencil-square-o"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
