<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2" />
    <title>Media Browser - Website Page Builder</title>
    
    <!-- jQuery and jQuery UI (REQUIRED) -->
    <script src="<?php echo base_url('assets/plugins/jquery/jquery.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/plugins/jquery-ui/jquery-ui.min.js'); ?>"></script>
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo base_url('assets/plugins/bootstrap/css/bootstrap.min.css'); ?>">
    
    <!-- elFinder CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/plugins/elFinder/themes/Material/css/theme-gray.css?v='.get_app_version()); ?>">
    
    <!-- elFinder JS -->
    <script src="<?php echo base_url('assets/plugins/elFinder/js/elfinder.min.js?v='.get_app_version()); ?>"></script>
    
    <?php
    $mediaLocale = get_media_locale();
    if($mediaLocale != 'en' && file_exists(FCPATH.'assets/plugins/elFinder/js/i18n/elfinder.'.$mediaLocale.'.js')){ ?>
        <script src="<?php echo base_url('assets/plugins/elFinder/js/i18n/elfinder.'.$mediaLocale.'.js?v='.get_app_version()); ?>"></script>
    <?php } ?>
    
    <style>
        body {
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
        }
        .media-browser-header {
            background: white;
            padding: 15px 20px;
            border-radius: 8px 8px 0 0;
            border-bottom: 1px solid #dee2e6;
            margin-bottom: 0;
        }
        .media-browser-body {
            background: white;
            border-radius: 0 0 8px 8px;
            min-height: 500px;
        }
        #elfinder {
            height: 500px;
        }
        .selected-files {
            background: #e3f2fd;
            padding: 10px;
            border-radius: 4px;
            margin-top: 10px;
            display: none;
        }
        .selected-file {
            display: inline-block;
            margin: 5px;
            padding: 5px 10px;
            background: #2196f3;
            color: white;
            border-radius: 4px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="media-browser-header">
            <div class="row">
                <div class="col-md-8">
                    <h4><i class="fa fa-folder-open"></i> Media Library</h4>
                    <p class="text-muted">Select images and media files for your website</p>
                </div>
                <div class="col-md-4 text-right">
                    <button type="button" class="btn btn-primary" id="select-files-btn" disabled>
                        <i class="fa fa-check"></i> Select Files
                    </button>
                    <button type="button" class="btn btn-default" onclick="window.close();">
                        <i class="fa fa-times"></i> Cancel
                    </button>
                </div>
            </div>
        </div>
        
        <div class="media-browser-body">
            <div id="elfinder"></div>
            
            <div class="selected-files" id="selected-files">
                <h6>Selected Files:</h6>
                <div id="selected-files-list"></div>
            </div>
        </div>
    </div>

    <script src="//cdnjs.cloudflare.com/ajax/libs/require.js/2.3.2/require.min.js"></script>
    <script>
        var selectedFiles = [];
        var siteUrl = '<?php echo site_url(); ?>';
        var mediaFolder = '<?php echo $this->app->get_media_folder(); ?>';
        
        define('elFinderConfig', {
            defaultOpts: {
                url: '<?php echo admin_url("utilities/media_connector"); ?>',
                onlyMimes: ['image', 'video', 'application/pdf'],
                commandsOptions: {
                    edit: {
                        extraOptions: {
                            managerUrl: ''
                        }
                    }
                },
                bootCallback: function(fm, extraObj) {
                    fm.bind('init', function() {
                        // Customize elFinder for page builder
                        fm.bind('select', function(e) {
                            updateSelectedFiles();
                        });
                        
                        fm.bind('open', function() {
                            updateSelectedFiles();
                        });
                    });
                }
            },
            managers: {
                'elfinder': {
                    ui: ['toolbar', 'tree', 'path', 'stat'],
                    uiOptions: {
                        toolbar: [
                            ['back', 'forward'],
                            ['mkdir', 'upload'],
                            ['open', 'download'],
                            ['quicklook'],
                            ['copy', 'paste'],
                            ['rm'],
                            ['duplicate', 'rename'],
                            ['search'],
                            ['view'],
                            ['info'],
                        ],
                    },
                    contextmenu: {
                        files: [
                            'getfile', '|', 'open', 'quicklook', '|', 'download', '|', 
                            'copy', 'cut', 'paste', 'duplicate', '|', 'rm', '|', 
                            'edit', 'rename', '|', 'archive', 'extract'
                        ]
                    }
                }
            }
        });

        function updateSelectedFiles() {
            var fm = $('#elfinder').elfinder('instance');
            if (!fm) return;
            
            selectedFiles = [];
            var selected = fm.getSelected();
            
            if (selected && selected.length > 0) {
                selected.forEach(function(hash) {
                    var file = fm.file(hash);
                    if (file && file.mime && file.mime.startsWith('image/')) {
                        var fileUrl = siteUrl + mediaFolder + '/' + file.name;
                        selectedFiles.push({
                            name: file.name,
                            url: fileUrl,
                            hash: hash
                        });
                    }
                });
            }
            
            updateSelectedFilesDisplay();
            updateSelectButton();
        }
        
        function updateSelectedFilesDisplay() {
            var container = $('#selected-files-list');
            container.empty();
            
            if (selectedFiles.length > 0) {
                $('#selected-files').show();
                selectedFiles.forEach(function(file) {
                    container.append('<span class="selected-file">' + file.name + '</span>');
                });
            } else {
                $('#selected-files').hide();
            }
        }
        
        function updateSelectButton() {
            var btn = $('#select-files-btn');
            if (selectedFiles.length > 0) {
                btn.prop('disabled', false);
                btn.text('Select ' + selectedFiles.length + ' File(s)');
            } else {
                btn.prop('disabled', true);
                btn.text('Select Files');
            }
        }
        
        // Select files button click
        $('#select-files-btn').click(function() {
            if (selectedFiles.length > 0) {
                // Send selected files to parent window
                if (window.opener && window.opener.selectMediaFiles) {
                    window.opener.selectMediaFiles(selectedFiles);
                } else {
                    // Fallback: try to communicate with parent
                    parent.postMessage({
                        type: 'mediaSelected',
                        files: selectedFiles
                    }, '*');
                }
                window.close();
            }
        });
        
        // Listen for messages from parent
        window.addEventListener('message', function(event) {
            if (event.data.type === 'requestMediaSelection') {
                updateSelectedFiles();
            }
        });

        require(['elfinder', 'extras/editors.default', 'elFinderConfig'], function() {
            // elFinder is ready
        }, function(error) {
            console.error('elFinder loading error:', error);
        });
    </script>
</body>
</html>
