<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
.btn-group .btn {
    margin-right: 2px;
}
.btn-group .btn:last-child {
    margin-right: 0;
}
.table td {
    vertical-align: middle;
}
.table th:last-child,
.table td:last-child {
    text-align: right;
    width: 200px;
}
.options-column {
    text-align: right !important;
    white-space: nowrap;
}
.btn i {
    font-size: 12px;
    display: inline-block;
    width: 14px;
    text-align: center;
}
.btn-sm {
    padding: 6px 8px;
    font-size: 11px;
    line-height: 1.2;
    min-width: 32px;
}
.btn-warning {
    background-color: #f0ad4e;
    border-color: #eea236;
    color: #fff;
}
.btn-warning:hover {
    background-color: #ec971f;
    border-color: #d58512;
    color: #fff;
}
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin"><?php echo _l('pages'); ?></h4>
                                <hr class="hr-panel-heading" />
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="btn-group pull-right">
                                    <a href="<?php echo admin_url('website/add_page'); ?>" class="btn btn-info">
                                        <i class="fa fa-plus"></i> Add New
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                        <thead>
                                            <tr>
                                                <th><?php echo _l('title'); ?></th>
                                                <th><?php echo _l('slug'); ?></th>
                                                <th><?php echo _l('status'); ?></th>
                                                <th><?php echo _l('created_at'); ?></th>
                                                <th class="text-right"><?php echo _l('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($pages)): ?>
                                                <?php foreach ($pages as $page): ?>
                                                    <tr>
                                                        <td>
                                                            <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>">
                                                                <?php echo $page->title; ?>
                                                            </a>
                                                        </td>
                                                        <td><?php echo $page->slug; ?></td>
                                                        <td>
                                                            <span class="label label-<?php echo $page->status == 'published' ? 'success' : ($page->status == 'draft' ? 'warning' : 'default'); ?>">
                                                                <?php echo ucfirst($page->status); ?>
                                                            </span>
                                                        </td>
                                                        <td><?php echo _dt($page->created_at); ?></td>
                                                        <td class="options-column">
                                                            <div class="btn-group" role="group">
                                                                <a href="<?php echo base_url($page->slug); ?>" target="_blank" class="btn btn-info btn-sm" title="View Page">
                                                                    <i class="fa fa-eye"></i>
                                                                </a>
                                                                <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>" class="btn btn-warning btn-sm" title="Edit Page">
                                                                    <i class="fa fa-edit"></i>
                                                                </a>
                                                                <?php if ($page->status == 'published'): ?>
                                                                    <a href="<?php echo admin_url('website/unpublish_page/' . $page->id); ?>" class="btn btn-default btn-sm _unpublish" title="Unpublish" data-toggle="tooltip">
                                                                        <i class="fa fa-eye-slash"></i>
                                                                    </a>
                                                                <?php else: ?>
                                                                    <a href="<?php echo admin_url('website/publish_page/' . $page->id); ?>" class="btn btn-success btn-sm _publish" title="Publish" data-toggle="tooltip">
                                                                        <i class="fa fa-check"></i>
                                                                    </a>
                                                                <?php endif; ?>
                                                                <a href="<?php echo admin_url('website/duplicate_page/' . $page->id); ?>" class="btn btn-primary btn-sm" title="Duplicate Page" data-toggle="tooltip">
                                                                    <i class="fa fa-copy"></i>
                                                                </a>
                                                                <a href="<?php echo admin_url('website/delete_page/' . $page->id); ?>" class="btn btn-danger btn-sm _delete" title="Delete Page" data-toggle="tooltip">
                                                                    <i class="fa fa-trash"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <tr>
                                                    <td colspan="5" class="text-center"><?php echo _l('no_pages_found'); ?></td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Delete confirmation
    $('._delete').on('click', function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        if (confirm('Are you sure you want to delete this page? This action cannot be undone.')) {
            window.location.href = url;
        }
    });
    
    // Publish confirmation
    $('._publish').on('click', function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        if (confirm('Are you sure you want to publish this page?')) {
            window.location.href = url;
        }
    });
    
    // Unpublish confirmation
    $('._unpublish').on('click', function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        if (confirm('Are you sure you want to unpublish this page?')) {
            window.location.href = url;
        }
    });
});
</script>
