<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $this->load->view('frontend/includes/header'); ?>

<div class="container-fluid py-5">
    <div class="container">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="display-4 text-primary"><?php echo $title; ?></h1>
                    <p class="lead">Discover our delicious selection of fresh baked goods</p>
                </div>
            </div>
        </div>

        <!-- Filters and Cart -->
        <div class="row mb-4">
            <div class="col-md-4">
                <select name="product_categories" class="form-control form-control-lg" onchange="filterByCategory(this.value)">
                    <option value="0">All Categories</option>
                    <?php foreach ($group_product as $category): ?>
                        <option value="<?php echo $category['id']; ?>" <?php echo ($category['id'] == $group_id) ? 'selected' : ''; ?>>
                            <?php echo html_entity_decode($category['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-8 text-right">
                <a href="<?php echo site_url('website/cart'); ?>" class="btn btn-success btn-lg">
                    <i class="fa fa-shopping-cart"></i> View Cart
                    <span class="badge badge-light ml-2" id="cart-count">0</span>
                </a>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="row">
            <?php if (!empty($product)): ?>
                <?php foreach ($product as $item): ?>
                    <div class="col-lg-<?php echo floor(12/$portal_row_product_show); ?> col-md-6 col-sm-6 mb-4">
                        <div class="card product-card h-100 shadow-sm">
                            <div class="product-image position-relative">
                                <a href="<?php echo site_url('website/product/' . $item['id']); ?>">
                                    <img src="<?php echo $item['image']; ?>" 
                                         class="card-img-top" 
                                         alt="<?php echo htmlspecialchars($item['name']); ?>"
                                         style="height: 250px; object-fit: cover;">
                                </a>
                                <?php if ($item['price_discount'] > 0): ?>
                                    <span class="badge badge-danger position-absolute" style="top: 10px; right: 10px;">
                                        Sale!
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">
                                    <a href="<?php echo site_url('website/product/' . $item['id']); ?>" class="text-decoration-none">
                                        <?php echo html_entity_decode($item['name']); ?>
                                    </a>
                                </h5>
                                <p class="card-text text-muted small">
                                    <?php echo html_entity_decode(substr($item['description'], 0, 100)) . '...'; ?>
                                </p>
                                <div class="price-section mt-auto">
                                    <div class="price mb-3">
                                        <?php if ($item['price_discount'] > 0): ?>
                                            <span class="old-price text-muted text-decoration-line-through">
                                                <?php echo app_format_money($item['price'], $base_currency->name); ?>
                                            </span>
                                            <span class="new-price text-danger font-weight-bold h5">
                                                <?php echo app_format_money($item['price_discount'], $base_currency->name); ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="current-price text-primary font-weight-bold h5">
                                                <?php echo app_format_money($item['price'], $base_currency->name); ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="add-to-cart">
                                        <?php if ($item['w_quantity'] > 0): ?>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <button class="btn btn-outline-secondary btn-sm qty-minus" type="button" data-id="<?php echo $item['id']; ?>">
                                                        <i class="fa fa-minus"></i>
                                                    </button>
                                                </div>
                                                <input type="number" 
                                                       class="form-control text-center qty-input" 
                                                       value="1" 
                                                       min="1" 
                                                       max="<?php echo $item['w_quantity']; ?>" 
                                                       data-id="<?php echo $item['id']; ?>"
                                                       style="max-width: 80px;">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary btn-sm qty-plus" type="button" data-id="<?php echo $item['id']; ?>">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <button class="btn btn-primary btn-block mt-2 add-to-cart-btn" data-id="<?php echo $item['id']; ?>">
                                                <i class="fa fa-shopping-cart"></i> Add to Cart
                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn-secondary btn-block" disabled>
                                                <i class="fa fa-times"></i> Out of Stock
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="alert alert-info text-center py-5">
                        <i class="fa fa-info-circle fa-3x mb-3"></i>
                        <h4>No products found</h4>
                        <p>Please try a different category or search term.</p>
                        <a href="<?php echo site_url('website/products'); ?>" class="btn btn-primary">
                            View All Products
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if ($total_page > 1): ?>
            <div class="row mt-5">
                <div class="col-12">
                    <nav aria-label="Product pagination">
                        <ul class="pagination justify-content-center">
                            <?php if ($page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo site_url('website/products/' . ($page - 1) . '/' . $group_id); ?>">
                                        <i class="fa fa-chevron-left"></i> Previous
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <?php for ($i = max(1, $page - 2); $i <= min($total_page, $page + 2); $i++): ?>
                                <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                    <a class="page-link" href="<?php echo site_url('website/products/' . $i . '/' . $group_id); ?>">
                                        <?php echo $i; ?>
                                    </a>
                                </li>
                            <?php endfor; ?>
                            
                            <?php if ($page < $total_page): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo site_url('website/products/' . ($page + 1) . '/' . $group_id); ?>">
                                        Next <i class="fa fa-chevron-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.product-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    border-radius: 15px;
    overflow: hidden;
}

.product-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1) !important;
}

.product-image img {
    transition: transform 0.3s ease;
}

.product-card:hover .product-image img {
    transform: scale(1.05);
}

.price .old-price {
    font-size: 0.9em;
}

.price .new-price,
.price .current-price {
    font-size: 1.2em;
}

.qty-input {
    border-left: none;
    border-right: none;
}

.qty-minus,
.qty-plus {
    border-radius: 0;
}

.add-to-cart-btn {
    border-radius: 25px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.add-to-cart-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0,123,255,0.3);
}

.page-header h1 {
    font-weight: 700;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
}

.badge {
    font-size: 0.8em;
    padding: 0.5em 0.75em;
}
</style>

<script>
$(document).ready(function() {
    // Category filter
    function filterByCategory(categoryId) {
        window.location.href = '<?php echo site_url("website/products/1/"); ?>' + categoryId;
    }

    // Quantity controls
    $('.qty-minus').click(function() {
        var input = $(this).siblings('.qty-input');
        var currentVal = parseInt(input.val());
        if (currentVal > 1) {
            input.val(currentVal - 1);
        }
    });

    $('.qty-plus').click(function() {
        var input = $(this).siblings('.qty-input');
        var currentVal = parseInt(input.val());
        var maxVal = parseInt(input.attr('max'));
        if (currentVal < maxVal) {
            input.val(currentVal + 1);
        }
    });

    // Add to cart functionality
    $('.add-to-cart-btn').click(function() {
        var productId = $(this).data('id');
        var quantity = $(this).siblings('.input-group').find('.qty-input').val();
        
        addToCart(productId, quantity);
    });

    // Add to cart function
    function addToCart(productId, quantity) {
        $.ajax({
            url: '<?php echo site_url("website/add_to_cart"); ?>',
            type: 'POST',
            data: {
                product_id: productId,
                quantity: quantity
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showAlert('Product added to cart!', 'success');
                    updateCartCount();
                } else {
                    showAlert(response.message || 'Error adding product to cart', 'error');
                }
            },
            error: function() {
                showAlert('Error adding product to cart', 'error');
            }
        });
    }

    // Show alert function
    function showAlert(message, type) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">' +
                       '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                       message +
                       '</div>';
        $('body').append(alertHtml);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 3000);
    }

    // Update cart count
    function updateCartCount() {
        // This would typically make an AJAX call to get the current cart count
        // For now, we'll just increment the displayed count
        var currentCount = parseInt($('#cart-count').text()) || 0;
        $('#cart-count').text(currentCount + 1);
    }

    // Load cart count on page load
    loadCartCount();
    
    function loadCartCount() {
        $.ajax({
            url: '<?php echo site_url("website/get_cart_count"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('#cart-count').text(response.count);
                }
            }
        });
    }
});
</script>

<?php $this->load->view('frontend/includes/footer'); ?>

