<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Website Management
Description: Complete website management system with page builder, templates, and content management with e-commerce integration
Version: 1.0.0
Requires at least: 2.3.*
Author: ERP Development Team
Author URI: https://erp-ecom.com
*/

define('WEBSITE_MODULE_NAME', 'website');
define('WEBSITE_MODULE_UPLOAD_FOLDER', module_dir_path(WEBSITE_MODULE_NAME, 'uploads'));
define('WEBSITE_PATH', 'modules/website/uploads/');
define('WEBSITE_APP_PATH', 'modules/website/');

// Add hooks
hooks()->add_action('app_admin_head', 'website_add_head_component');
hooks()->add_action('app_admin_footer', 'website_load_js');
hooks()->add_action('admin_init', 'website_module_init_menu_items');
hooks()->add_action('admin_init', 'website_permissions');

// Register activation module hook
register_activation_hook(WEBSITE_MODULE_NAME, 'website_module_activation_hook');

// Register deactivation module hook
register_deactivation_hook(WEBSITE_MODULE_NAME, 'website_module_deactivation_hook');

// Register language files
register_language_files(WEBSITE_MODULE_NAME, [WEBSITE_MODULE_NAME]);

/**
 * Website module activation hook
 */
function website_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Init add head component
 */
function website_add_head_component()
{
    $CI = &get_instance();
    $viewuri = $_SERVER['REQUEST_URI'];
    
    if (!(strpos($viewuri, 'admin/website') === false)) {
        echo '<link href="' . module_dir_url(WEBSITE_MODULE_NAME, 'assets/css/website.css') . '" rel="stylesheet" type="text/css" />';
    }
}

/**
 * Init add footer component
 */
function website_load_js()
{
    $CI = &get_instance();
    $viewuri = $_SERVER['REQUEST_URI'];
    
    if (!(strpos($viewuri, 'admin/website') === false)) {
        echo '<script src="' . module_dir_url(WEBSITE_MODULE_NAME, 'assets/js/website.js') . '"></script>';
    }
    
    // Load e-commerce JavaScript for frontend pages
    if (strpos($viewuri, 'website/products') !== false || 
        strpos($viewuri, 'website/product/') !== false || 
        strpos($viewuri, 'website/cart') !== false ||
        strpos($viewuri, 'website/checkout') !== false) {
        
        echo '<script src="' . module_dir_url(WEBSITE_MODULE_NAME, 'assets/js/ecommerce.js') . '"></script>';
        
        // Set global variables for JavaScript
        echo '<script>';
        echo 'window.isClientLoggedIn = ' . (is_client_logged_in() ? 'true' : 'false') . ';';
        echo 'window.websiteApiUrl = "' . site_url('website/api/') . '";';
        echo '</script>';
    }
}

/**
 * Init website module menu items in admin_init hook
 * @return null
 */
function website_module_init_menu_items()
{
    $CI = &get_instance();
    
    if (is_admin() || has_permission('website', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('website', [
            'name'     => _l('website'),
            'icon'     => 'fa fa-globe',
            'href'     => admin_url('website'),
            'position' => 10,
        ]);

        if (is_admin() || has_permission('website', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('website', [
                'slug'     => 'website_pages',
                'name'     => _l('pages'),
                'icon'     => 'fa fa-file-text',
                'href'     => admin_url('website/pages'),
            ]);

            $CI->app_menu->add_sidebar_children_item('website', [
                'slug'     => 'website_templates',
                'name'     => _l('templates'),
                'icon'     => 'fa fa-paint-brush',
                'href'     => admin_url('website/templates'),
            ]);

            $CI->app_menu->add_sidebar_children_item('website', [
                'slug'     => 'website_media',
                'name'     => _l('media_library'),
                'icon'     => 'fa fa-image',
                'href'     => admin_url('website/media'),
            ]);

            $CI->app_menu->add_sidebar_children_item('website', [
                'slug'     => 'website_navigation',
                'name'     => _l('navigation'),
                'icon'     => 'fa fa-bars',
                'href'     => admin_url('website/navigation'),
            ]);

            $CI->app_menu->add_sidebar_children_item('website', [
                'slug'     => 'website_settings',
                'name'     => _l('settings'),
                'icon'     => 'fa fa-cog',
                'href'     => admin_url('website/settings'),
            ]);
        }
    }
}

/**
 * Website permissions
 */
function website_permissions()
{
    $capabilities = [];
    $capabilities['capabilities'] = [
        'view'   => _l('permission_view'),
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('website', $capabilities, _l('website'));
}

/**
 * Module deactivation hook
 */
function website_module_deactivation_hook()
{
    // Cleanup operations if needed
    return true;
}