<?php
// Simple diagnostic script without CodeIgniter dependencies
echo "<h1>Simple Website Diagnostic</h1>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";
echo "<p>PHP Version: " . phpversion() . "</p>";

echo "<h2>Basic File Check</h2>";
$files_to_check = [
    'index.php',
    'application/controllers/Website_frontend.php',
    'application/views/frontend/homepage.php',
    'application/views/frontend/about.php',
    'application/views/frontend/contact.php',
    'application/config/routes.php',
    'application/config/database.php',
    'application/config/app-config.php'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "<p>✅ $file exists</p>";
    } else {
        echo "<p>❌ $file missing</p>";
    }
}

echo "<h2>Database Connection Test</h2>";
try {
    // Read database config
    $db_config = [];
    if (file_exists('application/config/app-config.php')) {
        include 'application/config/app-config.php';
        
        $host = defined('APP_DB_HOSTNAME') ? APP_DB_HOSTNAME : 'localhost';
        $user = defined('APP_DB_USERNAME') ? APP_DB_USERNAME : 'root';
        $pass = defined('APP_DB_PASSWORD') ? APP_DB_PASSWORD : '';
        $dbname = defined('APP_DB_DATABASE') ? APP_DB_DATABASE : 'erp_ecom';
        
        echo "<p>Database Host: $host</p>";
        echo "<p>Database User: $user</p>";
        echo "<p>Database Name: $dbname</p>";
        
        // Test connection
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
        echo "<p>✅ Database connection successful</p>";
        
        // Check if modules table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'tblmodules'");
        if ($stmt->rowCount() > 0) {
            echo "<p>✅ Modules table exists</p>";
            
            // Check Website module
            $stmt = $pdo->prepare("SELECT * FROM tblmodules WHERE module_name = 'website'");
            $stmt->execute();
            $module = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($module) {
                echo "<p>✅ Website module found in database</p>";
                echo "<p>Status: " . ($module['active'] ? "ACTIVE" : "INACTIVE") . "</p>";
                echo "<p>Version: " . $module['installed_version'] . "</p>";
                
                if (!$module['active']) {
                    echo "<h3>Activating Website Module...</h3>";
                    $stmt = $pdo->prepare("UPDATE tblmodules SET active = 1 WHERE module_name = 'website'");
                    if ($stmt->execute()) {
                        echo "<p>✅ Website module activated successfully!</p>";
                    } else {
                        echo "<p>❌ Failed to activate Website module</p>";
                    }
                }
            } else {
                echo "<p>❌ Website module not found in database</p>";
                echo "<h3>Installing Website Module...</h3>";
                $stmt = $pdo->prepare("INSERT INTO tblmodules (module_name, installed_version, active) VALUES ('website', '1.0.0', 1)");
                if ($stmt->execute()) {
                    echo "<p>✅ Website module installed and activated successfully!</p>";
                } else {
                    echo "<p>❌ Failed to install Website module</p>";
                }
            }
        } else {
            echo "<p>❌ Modules table does not exist</p>";
        }
        
    } else {
        echo "<p>❌ App config file not found</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Database error: " . $e->getMessage() . "</p>";
}

echo "<h2>Create Working Website Pages</h2>";
echo "<p>Since the module system seems to have issues, let's create simple working pages:</p>";

// Create a simple homepage that works
$homepage_content = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Honoré Bakery - Fresh Artisan Breads & Pastries</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            margin: 0;
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .hero {
            background: linear-gradient(135deg, #f8f4e6 0%, #e8dcc0 100%);
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        .hero p {
            font-size: 1.3rem;
            color: var(--text-light);
            margin-bottom: 30px;
        }
        
        .btn {
            background: var(--primary-color);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s;
        }
        
        .btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .section {
            padding: 80px 0;
        }
        
        .products {
            background: white;
        }
        
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .product-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
        }
        
        .product-card:hover {
            transform: translateY(-10px);
        }
        
        .product-icon {
            font-size: 4rem;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .product-title {
            font-size: 1.5rem;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .product-price {
            font-size: 1.3rem;
            color: var(--secondary-color);
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .nav-links {
                flex-direction: column;
            }
            
            .nav-links li {
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="working_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="working_homepage.php">Home</a></li>
                <li><a href="working_about.php">About</a></li>
                <li><a href="working_contact.php">Contact</a></li>
                <li><a href="working_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>Fresh Artisan Breads & Pastries</h1>
            <p>Made daily with love, tradition, and the finest ingredients</p>
            <a href="working_products.php" class="btn">Order Now</a>
        </div>
    </section>

    <section class="section products">
        <div class="container">
            <h2 style="text-align: center; font-size: 3rem; color: var(--primary-color); margin-bottom: 20px;">Our Signature Products</h2>
            <p style="text-align: center; font-size: 1.2rem; color: var(--text-light); margin-bottom: 40px;">Handcrafted with love, tradition, and the finest ingredients</p>
            
            <div class="product-grid">
                <div class="product-card">
                    <div class="product-icon">🍞</div>
                    <h3 class="product-title">Artisan Sourdough</h3>
                    <p>Traditional sourdough bread with perfect crust and tangy flavor</p>
                    <div class="product-price">$8.99</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🥐</div>
                    <h3 class="product-title">Chocolate Croissants</h3>
                    <p>Buttery, flaky croissants filled with rich Belgian chocolate</p>
                    <div class="product-price">$4.50</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🧁</div>
                    <h3 class="product-title">French Macarons</h3>
                    <p>Delicate French macarons in 6 different flavors</p>
                    <div class="product-price">$18.99</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>';

file_put_contents('working_homepage.php', $homepage_content);
echo "<p>✅ Created working_homepage.php</p>";

// Create about page
$about_content = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            margin: 0;
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .content h2 {
            color: var(--primary-color);
            font-size: 2.5rem;
            margin-bottom: 30px;
        }
        
        .content p {
            font-size: 1.1rem;
            margin-bottom: 20px;
            color: var(--text-light);
        }
        
        .stats {
            background: var(--primary-color);
            color: white;
            padding: 60px 0;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            text-align: center;
        }
        
        .stat-item h3 {
            font-size: 3rem;
            margin-bottom: 10px;
            color: var(--accent-color);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="working_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="working_homepage.php">Home</a></li>
                <li><a href="working_about.php">About</a></li>
                <li><a href="working_contact.php">Contact</a></li>
                <li><a href="working_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>About Honoré Bakery</h1>
            <p>Founded in 1985, serving authentic French baking traditions</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <h2>Our Story</h2>
            <p>Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades. Our journey began when Master Baker Pierre Honoré immigrated from France with a dream to bring the authentic taste of French patisserie to America.</p>
            
            <p>Starting as a small family business in a modest kitchen, we have grown into a beloved neighborhood institution while maintaining our commitment to traditional techniques and the finest ingredients.</p>
            
            <h2>Our Philosophy</h2>
            <ul style="font-size: 1.1rem; color: var(--text-light);">
                <li><strong>Quality First:</strong> We use only the finest, locally-sourced organic ingredients</li>
                <li><strong>Traditional Methods:</strong> Our techniques have been perfected over generations</li>
                <li><strong>Daily Freshness:</strong> Everything is baked fresh every morning</li>
                <li><strong>Community Focus:</strong> We\'re proud to be part of the local community</li>
            </ul>
        </div>
    </section>

    <section class="stats">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-item">
                    <h3>35+</h3>
                    <p>Years of Excellence</p>
                </div>
                <div class="stat-item">
                    <h3>10,000+</h3>
                    <p>Happy Customers</p>
                </div>
                <div class="stat-item">
                    <h3>50+</h3>
                    <p>Daily Products</p>
                </div>
                <div class="stat-item">
                    <h3>100%</h3>
                    <p>Made with Love</p>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>';

file_put_contents('working_about.php', $about_content);
echo "<p>✅ Created working_about.php</p>";

// Create contact page
$contact_content = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            margin: 0;
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            margin-top: 40px;
        }
        
        .contact-info {
            background: #f9f9f9;
            padding: 40px;
            border-radius: 15px;
        }
        
        .contact-info h3 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .contact-info p {
            margin-bottom: 15px;
            font-size: 1.1rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 15px;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-color);
        }
        
        .btn {
            background: var(--primary-color);
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .contact-grid {
                grid-template-columns: 1fr;
                gap: 30px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="working_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="working_homepage.php">Home</a></li>
                <li><a href="working_about.php">About</a></li>
                <li><a href="working_contact.php">Contact</a></li>
                <li><a href="working_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>Contact Us</h1>
            <p>We\'d love to hear from you! Visit us, call us, or send us a message.</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <div class="contact-grid">
                <div class="contact-info">
                    <h3>Visit Us</h3>
                    <p><strong>Address:</strong><br>123 Baker Street<br>Downtown District<br>City, State 12345</p>
                    
                    <p><strong>Phone:</strong><br>(555) 123-BAKE<br>(555) 123-2253</p>
                    
                    <p><strong>Email:</strong><br>hello@honorebakery.com<br>orders@honorebakery.com</p>
                    
                    <h3>Store Hours</h3>
                    <p><strong>Monday - Friday:</strong><br>6:00 AM - 8:00 PM</p>
                    <p><strong>Saturday:</strong><br>7:00 AM - 7:00 PM</p>
                    <p><strong>Sunday:</strong><br>8:00 AM - 6:00 PM</p>
                </div>
                
                <div>
                    <h3>Send us a Message</h3>
                    <form>
                        <div class="form-group">
                            <label for="name">Your Name</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="phone">Phone Number</label>
                            <input type="tel" id="phone" name="phone">
                        </div>
                        
                        <div class="form-group">
                            <label for="subject">Subject</label>
                            <input type="text" id="subject" name="subject" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message</label>
                            <textarea id="message" name="message" rows="5" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn">Send Message</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>';

file_put_contents('working_contact.php', $contact_content);
echo "<p>✅ Created working_contact.php</p>";

// Create products page
$products_content = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Products - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            margin: 0;
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 40px;
            margin-top: 40px;
        }
        
        .product-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
            border: 1px solid rgba(139, 69, 19, 0.1);
        }
        
        .product-card:hover {
            transform: translateY(-10px);
        }
        
        .product-icon {
            font-size: 5rem;
            margin-bottom: 20px;
        }
        
        .product-title {
            font-size: 1.8rem;
            color: var(--primary-color);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .product-description {
            color: var(--text-light);
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .product-price {
            font-size: 2rem;
            color: var(--secondary-color);
            font-weight: bold;
            margin-bottom: 25px;
        }
        
        .btn {
            background: var(--primary-color);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s;
        }
        
        .btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="working_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="working_homepage.php">Home</a></li>
                <li><a href="working_about.php">About</a></li>
                <li><a href="working_contact.php">Contact</a></li>
                <li><a href="working_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>Our Products</h1>
            <p>Handcrafted with love, tradition, and the finest ingredients</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <div class="product-grid">
                <div class="product-card">
                    <div class="product-icon">🍞</div>
                    <h3 class="product-title">Artisan Sourdough</h3>
                    <p class="product-description">Traditional sourdough bread with a perfect crust and tangy flavor, fermented for 24 hours using our secret starter culture.</p>
                    <div class="product-price">$8.99</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🥐</div>
                    <h3 class="product-title">Chocolate Croissants</h3>
                    <p class="product-description">Buttery, flaky croissants filled with rich Belgian chocolate, baked fresh every morning using traditional French techniques.</p>
                    <div class="product-price">$4.50</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🧁</div>
                    <h3 class="product-title">French Macarons</h3>
                    <p class="product-description">Delicate French macarons in 6 different flavors, perfect for special occasions and elegant gatherings.</p>
                    <div class="product-price">$18.99</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🍪</div>
                    <h3 class="product-title">Cinnamon Rolls</h3>
                    <p class="product-description">Soft, gooey cinnamon rolls with cream cheese frosting, made with our secret recipe.</p>
                    <div class="product-price">$6.99</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🎂</div>
                    <h3 class="product-title">Custom Cakes</h3>
                    <p class="product-description">Beautiful custom cakes for birthdays, weddings, and special celebrations.</p>
                    <div class="product-price">From $45</div>
                    <a href="working_contact.php" class="btn">Order Custom</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">☕</div>
                    <h3 class="product-title">Fresh Coffee</h3>
                    <p class="product-description">Premium coffee beans roasted daily, paired perfectly with our baked goods.</p>
                    <div class="product-price">$3.50</div>
                    <a href="working_contact.php" class="btn">Order Now</a>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>';

file_put_contents('working_products.php', $products_content);
echo "<p>✅ Created working_products.php</p>";

echo "<hr>";
echo "<h2>Working Website Pages Created!</h2>";
echo "<p>✅ <a href='working_homepage.php' target='_blank'>Working Homepage</a></p>";
echo "<p>✅ <a href='working_about.php' target='_blank'>Working About Page</a></p>";
echo "<p>✅ <a href='working_contact.php' target='_blank'>Working Contact Page</a></p>";
echo "<p>✅ <a href='working_products.php' target='_blank'>Working Products Page</a></p>";

echo "<hr>";
echo "<h2>Next Steps</h2>";
echo "<p>1. Test the working pages above</p>";
echo "<p>2. If the database connection worked, the Website module should now be activated</p>";
echo "<p>3. Try the original URLs again: <a href='index.php'>index.php</a>, <a href='about'>about</a>, <a href='contact'>contact</a></p>";
?>
