<?php
// Simple test to show products directly
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><title>Products Test</title></head><body>";
echo "<h1>Products Database Test</h1>";

try {
    // Direct database connection
    $host = 'localhost';
    $username = 'root';
    $password = '';
    $database = 'erp_ecom';
    
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get products
    $stmt = $pdo->prepare('SELECT id, description, rate FROM tblitems WHERE rate > 0 LIMIT 10');
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Found " . count($products) . " products:</h2>";
    
    foreach ($products as $product) {
        echo "<div style='border: 1px solid #ccc; margin: 10px; padding: 10px; display: inline-block; width: 200px;'>";
        echo "<h3>{$product['description']}</h3>";
        echo "<p>ID: {$product['id']}</p>";
        echo "<p>Price: {$product['rate']}</p>";
        
        // Check for images in manufacturing directory
        $image_path = "modules/manufacturing/uploads/products/{$product['id']}/";
        if (is_dir($image_path)) {
            $files = scandir($image_path);
            foreach ($files as $file) {
                if ($file != '.' && $file != '..' && $file != 'index.html' && 
                    (strpos($file, '.jpg') !== false || strpos($file, '.jpeg') !== false || 
                     strpos($file, '.png') !== false || strpos($file, '.gif') !== false)) {
                    echo "<img src='$image_path$file' style='width: 100%; height: 120px; object-fit: cover;'>";
                    break;
                }
            }
        } else {
            echo "<div style='width: 100%; height: 120px; background: #f0f0f0; display: flex; align-items: center; justify-content: center;'>No Image</div>";
        }
        
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "<br>";
}

echo "</body></html>";
?>

