<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cart Test - Honoré Bakery</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="font-inter bg-gray-50">
    <?php include 'header_component.php'; ?>
    
    <main class="pt-8">
        <div class="max-w-4xl mx-auto px-4 py-16">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Cart Functionality Test</h1>
            
            <div class="bg-white p-6 rounded-lg shadow-lg">
                <h2 class="text-xl font-semibold mb-4">Test Instructions:</h2>
                <ol class="list-decimal list-inside space-y-2 text-gray-700">
                    <li>Click the cart icon (shopping bag) in the header</li>
                    <li>The cart sidebar should slide in from the right</li>
                    <li>Check the browser console (F12) for debug messages</li>
                </ol>
                
                <div class="mt-6 p-4 bg-blue-50 rounded-lg">
                    <h3 class="font-semibold text-blue-900 mb-2">Debug Information:</h3>
                    <p class="text-blue-800 text-sm">Open browser console (F12) to see debug messages about cart functionality.</p>
                </div>
                
                <div class="mt-6 p-4 bg-green-50 rounded-lg">
                    <h3 class="font-semibold text-green-900 mb-2">Test Products:</h3>
                    <div class="flex gap-4">
                        <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded" data-product-id="artisan-sourdough">
                            Add Artisan Sourdough
                        </button>
                        <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded" data-product-id="chocolate-croissants">
                            Add Chocolate Croissants
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </main>
    
    <?php include 'cart_component.php'; ?>
</body>
</html>
