<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cart Test - Bakery Demo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <div class="container mx-auto px-4 py-8">
        <h1 class="text-3xl font-bold mb-8">Cart Test Page</h1>
        
        <div class="grid gap-6">
            <!-- Test Add to Cart -->
            <div class="bg-white p-6 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-4">Test Add to Cart</h2>
                <button onclick="testAddToCart()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
                    Add Test Product to Cart
                </button>
                <div id="addResult" class="mt-4"></div>
            </div>
            
            <!-- View Cart Contents -->
            <div class="bg-white p-6 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-4">Current Cart Contents</h2>
                <button onclick="loadCart()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
                    Load Cart
                </button>
                <div id="cartContents" class="mt-4"></div>
            </div>
        </div>
    </div>

    <script>
        async function testAddToCart() {
            const resultDiv = document.getElementById('addResult');
            resultDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Adding to cart...';
            
            try {
                const response = await fetch('/erp-ecom/api/website/cart/add', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'product_id=5&quantity=1'
                });
                
                const data = await response.json();
                
                if (data.success) {
                    resultDiv.innerHTML = `
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                            <strong>Success!</strong> ${data.message}
                            <br>Cart count: ${data.data.cart_count}
                            <br>Product: ${data.data.product.name}
                        </div>
                    `;
                } else {
                    resultDiv.innerHTML = `
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                            <strong>Error!</strong> ${data.error}
                        </div>
                    `;
                }
            } catch (error) {
                resultDiv.innerHTML = `
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                        <strong>Network Error!</strong> ${error.message}
                    </div>
                `;
            }
        }
        
        async function loadCart() {
            const cartDiv = document.getElementById('cartContents');
            cartDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading cart...';
            
            try {
                const response = await fetch('/erp-ecom/api/website/cart');
                const data = await response.json();
                
                if (data.success) {
                    if (data.data.items.length === 0) {
                        cartDiv.innerHTML = `
                            <div class="bg-gray-100 border border-gray-300 text-gray-700 px-4 py-3 rounded">
                                Cart is empty (Count: ${data.data.count}, Total: ${data.data.total})
                            </div>
                        `;
                    } else {
                        let itemsHtml = '<div class="space-y-2">';
                        data.data.items.forEach(item => {
                            itemsHtml += `
                                <div class="border p-3 rounded">
                                    <strong>${item.name}</strong><br>
                                    Quantity: ${item.quantity}<br>
                                    Price: ${item.price}
                                </div>
                            `;
                        });
                        itemsHtml += '</div>';
                        
                        cartDiv.innerHTML = `
                            <div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded">
                                <strong>Cart Contents</strong><br>
                                Total Items: ${data.data.count}<br>
                                Total: ${data.data.total}
                                ${itemsHtml}
                            </div>
                        `;
                    }
                } else {
                    cartDiv.innerHTML = `
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                            <strong>Error!</strong> ${data.error || 'Failed to load cart'}
                        </div>
                    `;
                }
            } catch (error) {
                cartDiv.innerHTML = `
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                        <strong>Network Error!</strong> ${error.message}
                    </div>
                `;
            }
        }
        
        // Load cart on page load
        document.addEventListener('DOMContentLoaded', loadCart);
    </script>
</body>
</html>