<?php
// Test database connection outside CodeIgniter
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'erp_ecom';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Simple query
    $stmt = $pdo->prepare("SELECT id, description, rate FROM tblitems WHERE rate > 0 AND id > 10 LIMIT 5");
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h1>Test Products</h1>";
    echo "<p>Found " . count($products) . " products:</p>";
    
    foreach ($products as $product) {
        echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px;'>";
        echo "<h3>" . htmlspecialchars($product['description']) . "</h3>";
        echo "<p>Price: $" . $product['rate'] . "</p>";
        echo "<p>ID: " . $product['id'] . "</p>";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>

